/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Package.findByNameAndPkgTypeId", query="SELECT p FROM Package AS p WHERE p.name = :name AND p.packageType.id = :packageTypeId"), @NamedQuery(name="Package.findByNamePkgTypeResourceType", query="SELECT p FROM Package AS p WHERE p.name = :name AND p.packageType.name = :packageTypeName AND p.packageType.resourceType.id = :resourceTypeId")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_PACKAGE_ID_SEQ")
@Table(name="RHQ_PACKAGE")
public class Package
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_NAME_PKG_TYPE_ID = "Package.findByNameAndPkgTypeId";
    public static final String QUERY_FIND_BY_NAME_PKG_TYPE_RESOURCE_TYPE = "Package.findByNamePkgTypeResourceType";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="PACKAGE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(cascade={CascadeType.PERSIST})
    private PackageType packageType;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="CLASSIFICATION", nullable=true)
    private String classification;
    @OneToMany(mappedBy="generalPackage", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<PackageVersion> versions;

    public Package() {
    }

    public Package(String name, PackageType type) {
        this.setName(name);
        this.setPackageType(type);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    public void setPackageType(PackageType packageType) {
        this.packageType = packageType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public List<PackageVersion> getVersions() {
        return this.versions;
    }

    public void addVersion(PackageVersion version) {
        if (this.versions == null) {
            this.versions = new ArrayList<PackageVersion>();
        }
        this.versions.add(version);
        version.setGeneralPackage(this);
    }

    public void setVersions(List<PackageVersion> versions) {
        this.versions = versions;
    }

    public String toString() {
        return "Package[name=" + this.name + ",packageType=" + this.packageType + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Package)) {
            return false;
        }
        Package aPackage = (Package)o;
        if (this.name != null ? !this.name.equals(aPackage.name) : aPackage.name != null) {
            return false;
        }
        return !(this.packageType != null ? !this.packageType.equals(aPackage.packageType) : aPackage.packageType != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageType == null ? 0 : this.packageType.hashCode());
        return result;
    }
}

