/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.factory;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class ProfileServiceFactory {
    private static final Log LOG = LogFactory.getLog(ProfileServiceFactory.class);
    private static final String PROFILE_SERVICE_JNDI_NAME = "ProfileService";
    private static ProfileService profileService;
    private static ManagementView currentProfileView;
    private static final ProfileKey DEFAULT_PROFILE_KEY;

    @NotNull
    public static ProfileService getProfileService() {
        if (profileService == null) {
            InitialContext initialContext;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException e) {
                throw new RuntimeException("Failed to create JNDI InitialContext.", e);
            }
            try {
                profileService = (ProfileService)initialContext.lookup(PROFILE_SERVICE_JNDI_NAME);
            }
            catch (NamingException e) {
                throw new RuntimeException("Failed to lookup JNDI name 'ProfileService' from InitialContext.", e);
            }
        }
        return profileService;
    }

    public static ManagementView getCurrentProfileView() {
        if (currentProfileView == null) {
            currentProfileView = ProfileServiceFactory.getProfileService().getViewManager();
            ProfileServiceFactory.refreshCurrentProfileView();
        }
        return currentProfileView;
    }

    public static void refreshCurrentProfileView() {
        try {
            ProfileServiceFactory.loadProfile(ProfileServiceFactory.getCurrentProfileView());
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load default profile from current management view.", (Throwable)e);
        }
    }

    public static DeploymentManager getDeploymentManager() throws Exception {
        DeploymentManager deploymentManager = ProfileServiceFactory.getProfileService().getDeploymentManager();
        ProfileServiceFactory.loadProfile(deploymentManager);
        return deploymentManager;
    }

    private static void loadProfile(ManagementView managementView) {
        try {
            LOG.trace((Object)"Loading profile via ManagementView...");
            long startTime = System.currentTimeMillis();
            managementView.load();
            long elapsedTime = System.currentTimeMillis() - startTime;
            LOG.trace((Object)("Loaded profile via Management View in " + elapsedTime + " ms."));
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to load profile via Management View.", (Throwable)e);
        }
    }

    private static void loadProfile(DeploymentManager deploymentManager) {
        try {
            LOG.trace((Object)("Loading profile '" + DEFAULT_PROFILE_KEY + "' via Deployment Manager..."));
            long startTime = System.currentTimeMillis();
            deploymentManager.loadProfile(DEFAULT_PROFILE_KEY);
            long elapsedTime = System.currentTimeMillis() - startTime;
            LOG.trace((Object)("Loaded profile '" + DEFAULT_PROFILE_KEY + "' via Deployment Manager in " + elapsedTime + " ms."));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to load profile '" + DEFAULT_PROFILE_KEY + "' via Deployment Manager."), (Throwable)e);
        }
    }

    static {
        DEFAULT_PROFILE_KEY = new ProfileKey("default");
    }
}

