/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.inventory;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.inventory.CreateResourceRequest;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceRequest;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.server.inventory.ResourceFactoryServerService;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.ServerServices;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.inventory.CreateResourceRunner;
import org.rhq.core.pc.inventory.DeleteResourceRunner;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;

public class ResourceFactoryManager
extends AgentService
implements ContainerService,
ResourceFactoryAgentService {
    private static final int FACET_METHOD_TIMEOUT = 60000;
    private final Log log = LogFactory.getLog(ResourceFactoryManager.class);
    private PluginContainerConfiguration configuration;
    private ExecutorService executor;
    private PluginMetadataManager metadataManager;

    public ResourceFactoryManager() {
        super(ResourceFactoryAgentService.class);
    }

    public void initialize() {
        this.log.info((Object)"Initializing");
        this.metadataManager = PluginContainer.getInstance().getPluginManager().getMetadataManager();
        int corePoolSize = this.configuration.getResourceFactoryCoreThreadPoolSize();
        int keepAliveTime = this.configuration.getResourceFactoryKeepAliveTime();
        int maxPoolSize = this.configuration.getResourceFactoryMaxThreadPoolSize();
        this.executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, (long)keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new LoggingThreadFactory("ResourceFactory.executor", true));
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public CreateResourceResponse executeCreateResourceImmediately(CreateResourceRequest request) throws PluginContainerException {
        CreateResourceResponse response;
        ResourceType resourceType = this.metadataManager.getType(request.getResourceTypeName(), request.getPluginName());
        if (resourceType == null) {
            throw new PluginContainerException("Could not retrieve resource type for request: " + request);
        }
        String creationType = request.getResourceConfiguration() != null ? "configuration" : "package";
        this.log.debug((Object)("Creating " + creationType + "-based resource of type '" + request.getResourceTypeName() + "' and with parent with id " + request.getParentResourceId() + "..."));
        CreateResourceReport report = new CreateResourceReport(request.getResourceName(), resourceType, request.getPluginConfiguration(), request.getResourceConfiguration(), request.getPackageDetails());
        CreateChildResourceFacet facet = this.getCreateChildResourceFacet(request.getParentResourceId());
        CreateResourceRunner runner = new CreateResourceRunner(this, request.getParentResourceId(), facet, request.getRequestId(), report, this.configuration.isInsideAgent());
        try {
            response = (CreateResourceResponse)this.executor.submit(runner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Error during create resource callable", (Throwable)e);
        }
        return response;
    }

    public void createResource(CreateResourceRequest request) throws PluginContainerException {
        ResourceType resourceType = this.metadataManager.getType(request.getResourceTypeName(), request.getPluginName());
        if (resourceType == null) {
            throw new PluginContainerException("Could not retrieve resource type for request: " + request);
        }
        String creationType = request.getResourceConfiguration() != null ? "configuration" : "package";
        this.log.debug((Object)("Creating " + creationType + "-based resource of type '" + request.getResourceTypeName() + "' and with parent with id " + request.getParentResourceId() + "..."));
        CreateResourceReport report = new CreateResourceReport(request.getResourceName(), resourceType, request.getPluginConfiguration(), request.getResourceConfiguration(), request.getPackageDetails());
        CreateChildResourceFacet facet = this.getCreateChildResourceFacet(request.getParentResourceId());
        CreateResourceRunner runner = new CreateResourceRunner(this, request.getParentResourceId(), facet, request.getRequestId(), report, this.configuration.isInsideAgent());
        this.executor.submit(runner);
    }

    public DeleteResourceResponse executeDeleteResourceImmediately(DeleteResourceRequest request) throws PluginContainerException {
        DeleteResourceResponse response;
        int resourceId = request.getResourceId();
        DeleteResourceFacet facet = this.getDeleteResourceFacet(resourceId);
        DeleteResourceRunner runner = new DeleteResourceRunner(this, facet, request.getRequestId(), resourceId);
        try {
            response = (DeleteResourceResponse)this.executor.submit(runner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Error occurred in delete resource thread", (Throwable)e);
        }
        return response;
    }

    public void deleteResource(DeleteResourceRequest request) throws PluginContainerException {
        int resourceId = request.getResourceId();
        DeleteResourceFacet facet = this.getDeleteResourceFacet(resourceId);
        DeleteResourceRunner runner = new DeleteResourceRunner(this, facet, request.getRequestId(), resourceId);
        this.executor.submit(runner);
    }

    ResourceFactoryServerService getServerService() {
        ServerServices serverServices = this.configuration.getServerServices();
        if (serverServices == null) {
            return null;
        }
        ResourceFactoryServerService resourceFactoryServerService = serverServices.getResourceFactoryServerService();
        return resourceFactoryServerService;
    }

    private DeleteResourceFacet getDeleteResourceFacet(int resourceId) throws PluginContainerException {
        DeleteResourceFacet facet = ComponentUtil.getComponent(resourceId, DeleteResourceFacet.class, FacetLockType.WRITE, 60000L, false, true);
        return facet;
    }

    private CreateChildResourceFacet getCreateChildResourceFacet(int parentResourceId) throws PluginContainerException {
        CreateChildResourceFacet facet = ComponentUtil.getComponent(parentResourceId, CreateChildResourceFacet.class, FacetLockType.WRITE, 60000L, false, true);
        return facet;
    }

    @Nullable
    private PackageType getPackageType(ResourceType resourceType, String packageTypeName) {
        Set packageTypes = resourceType.getPackageTypes();
        for (PackageType packageType : packageTypes) {
            if (!packageType.getName().equals(packageTypeName)) continue;
            return packageType;
        }
        return null;
    }
}

