/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.context.CreationalContext;
import javax.inject.DefinitionException;
import javax.inject.Initializer;
import javax.persistence.EntityManager;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.ejb.EJBApiAbstraction;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.injection.ConstructorInjectionPoint;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedConstructor;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.persistence.PersistenceApiAbstraction;
import org.jboss.webbeans.persistence.spi.JpaServices;
import org.jboss.webbeans.resources.spi.ResourceServices;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBean<T>
extends AbstractClassBean<T> {
    private static LogProvider log = Logging.getLogProvider(SimpleBean.class);
    private ConstructorInjectionPoint<T> constructor;
    private AnnotatedMethod<?> postConstruct;
    private AnnotatedMethod<?> preDestroy;
    private Set<AnnotatedInjectionPoint<?, ?>> ejbInjectionPoints;
    private Set<AnnotatedInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private Set<AnnotatedInjectionPoint<?, ?>> resourceInjectionPoints;
    private SimpleBean<?> specializedBean;

    public static <T> SimpleBean<T> of(AnnotatedClass<T> clazz, ManagerImpl manager) {
        return new SimpleBean<T>(clazz, manager);
    }

    protected SimpleBean(AnnotatedClass<T> type, ManagerImpl manager) {
        super(type, manager);
        this.initType();
        this.initTypes();
        this.initBindings();
    }

    /*
     * Exception decompiling
     */
    public T create(CreationalContext<T> creationalContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance) {
        try {
            DependentContext.instance().setActive(true);
            this.callPreDestroy(instance);
            this.dependentInstancesStore.destroyDependentInstances(instance);
        }
        catch (Exception e) {
            log.error((Object)("Error destroying " + this.toString()), (Throwable)e);
        }
        finally {
            DependentContext.instance().setActive(false);
        }
    }

    protected void callPreDestroy(T instance) {
        AnnotatedMethod<?> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + preDestroy + " on " + instance, e);
            }
        }
    }

    protected void callPostConstruct(T instance) {
        AnnotatedMethod<?> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + postConstruct + " on " + instance, e);
            }
        }
    }

    protected void initEjbInjectionPoints() {
        Class<? extends Annotation> ejbAnnotationType = ((EJBApiAbstraction)this.manager.getServices().get(EJBApiAbstraction.class)).EJB_ANNOTATION_CLASS;
        this.ejbInjectionPoints = new HashSet();
        for (AnnotatedField<?> annotatedField : this.annotatedItem.getAnnotatedFields(ejbAnnotationType)) {
            this.ejbInjectionPoints.add(FieldInjectionPoint.of(this, annotatedField));
        }
        for (AnnotatedMethod annotatedMethod : this.annotatedItem.getAnnotatedMethods(ejbAnnotationType)) {
            this.ejbInjectionPoints.add(MethodInjectionPoint.of(this, annotatedMethod));
        }
    }

    protected void initPersistenceUnitInjectionPoints() {
        this.persistenceUnitInjectionPoints = new HashSet();
        Class<? extends Annotation> persistenceContextAnnotationType = ((PersistenceApiAbstraction)this.manager.getServices().get(PersistenceApiAbstraction.class)).PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
        Object extendedPersistenceContextEnum = ((PersistenceApiAbstraction)this.manager.getServices().get(PersistenceApiAbstraction.class)).EXTENDED_PERSISTENCE_CONTEXT_ENUM_VALUE;
        for (AnnotatedField<?> annotatedField : this.annotatedItem.getAnnotatedFields(persistenceContextAnnotationType)) {
            if (extendedPersistenceContextEnum.equals(Reflections.invokeAndWrap("type", (Object)annotatedField.getAnnotation(persistenceContextAnnotationType), new Object[0]))) {
                throw new DefinitionException("Cannot inject an extended persistence context into " + annotatedField);
            }
            this.persistenceUnitInjectionPoints.add(FieldInjectionPoint.of(this, annotatedField));
        }
        for (AnnotatedMethod annotatedMethod : this.annotatedItem.getAnnotatedMethods(persistenceContextAnnotationType)) {
            if (extendedPersistenceContextEnum.equals(Reflections.invokeAndWrap("type", (Object)annotatedMethod.getAnnotation(persistenceContextAnnotationType), new Object[0]))) {
                throw new DefinitionException("Cannot inject an extended persistence context into " + annotatedMethod);
            }
            this.persistenceUnitInjectionPoints.add(MethodInjectionPoint.of(this, annotatedMethod));
        }
    }

    protected void initResourceInjectionPoints() {
        Class<? extends Annotation> resourceAnnotationType = ((EJBApiAbstraction)this.manager.getServices().get(EJBApiAbstraction.class)).RESOURCE_ANNOTATION_CLASS;
        this.resourceInjectionPoints = new HashSet();
        for (AnnotatedField<?> field : this.annotatedItem.getAnnotatedFields(resourceAnnotationType)) {
            this.resourceInjectionPoints.add(FieldInjectionPoint.of(this, field));
        }
    }

    protected void injectEjbAndCommonFields(T beanInstance) {
        EjbServices ejbServices = (EjbServices)this.manager.getServices().get(EjbServices.class);
        JpaServices jpaServices = (JpaServices)this.manager.getServices().get(JpaServices.class);
        ResourceServices resourceServices = (ResourceServices)this.manager.getServices().get(ResourceServices.class);
        if (ejbServices != null) {
            for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.ejbInjectionPoints) {
                Object ejbInstance = ejbServices.resolveEjb(injectionPoint);
                injectionPoint.inject(beanInstance, ejbInstance);
            }
        }
        if (jpaServices != null) {
            for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.persistenceUnitInjectionPoints) {
                EntityManager puInstance = jpaServices.resolvePersistenceContext(injectionPoint);
                injectionPoint.inject(beanInstance, puInstance);
            }
        }
        if (resourceServices != null) {
            for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.resourceInjectionPoints) {
                Object resourceInstance = resourceServices.resolveResource(injectionPoint);
                injectionPoint.inject(beanInstance, resourceInstance);
            }
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initConstructor();
            this.checkType();
            this.initInjectionPoints();
            this.initPostConstruct();
            this.initPreDestroy();
            if (this.getManager().getServices().contains(EjbServices.class)) {
                this.initEjbInjectionPoints();
            }
            if (this.getManager().getServices().contains(JpaServices.class)) {
                this.initPersistenceUnitInjectionPoints();
            }
            if (this.getManager().getServices().contains(ResourceServices.class)) {
                this.initResourceInjectionPoints();
            }
        }
    }

    @Override
    protected void initInjectionPoints() {
        super.initInjectionPoints();
        for (ParameterInjectionPoint<?> parameter : this.constructor.getParameters()) {
            this.injectionPoints.add(ParameterInjectionPoint.of(this, parameter));
        }
    }

    protected void checkType() {
        if (this.getAnnotatedItem().isNonStaticMemberClass()) {
            throw new DefinitionException("Simple bean " + this.type + " cannot be a non-static inner class");
        }
        if (this.getAnnotatedItem().isParameterizedType()) {
            throw new DefinitionException("Simple bean " + this.type + " cannot be a parameterized type");
        }
        boolean passivating = ((MetaDataCache)this.manager.getServices().get(MetaDataCache.class)).getScopeModel(this.scopeType).isPassivating();
        if (passivating && !this._serializable) {
            throw new DefinitionException("Simple bean declaring a passivating scope must have a serializable implementation class " + this.toString());
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (!this.isDependent()) {
            for (AnnotatedField<?> field : this.getAnnotatedItem().getFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw new DefinitionException("Normal scoped Web Bean implementation class has a public field " + this.getAnnotatedItem());
            }
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (environment.getEjbDescriptors().containsKey(this.getAnnotatedItem().getSuperclass().getRawType())) {
            throw new DefinitionException("Simple bean must specialize a simple bean");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        if (environment.getClassBean(this.getAnnotatedItem().getSuperclass()) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        AbstractClassBean<?> specializedBean = environment.getClassBean(this.getAnnotatedItem().getSuperclass());
        if (!(specializedBean instanceof SimpleBean)) {
            throw new IllegalStateException(this.toString() + " doesn't have a simple bean as a superclass " + specializedBean);
        }
        this.specializedBean = (SimpleBean)specializedBean;
    }

    protected void initConstructor() {
        Set initializerAnnotatedConstructors = this.getAnnotatedItem().getAnnotatedConstructors(Initializer.class);
        log.trace((Object)("Found " + initializerAnnotatedConstructors + " constructors annotated with @Initializer for " + this.getType()));
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException("Cannot have more than one constructor annotated with @Initializer for " + this.getType());
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            this.constructor = ConstructorInjectionPoint.of(this, initializerAnnotatedConstructors.iterator().next());
            log.trace((Object)("Exactly one constructor (" + this.constructor + ") annotated with @Initializer defined, using it as the bean constructor for " + this.getType()));
            return;
        }
        if (this.getAnnotatedItem().getNoArgsConstructor() != null) {
            this.constructor = ConstructorInjectionPoint.of(this, this.getAnnotatedItem().getNoArgsConstructor());
            log.trace((Object)("Exactly one constructor (" + this.constructor + ") defined, using it as the bean constructor for " + this.getType()));
            return;
        }
        throw new DefinitionException("Cannot determine constructor to use for " + this.getType());
    }

    protected void initPostConstruct() {
        Set<AnnotatedMethod<?>> postConstructMethods = this.getAnnotatedItem().getAnnotatedMethods(PostConstruct.class);
        log.trace((Object)("Found " + postConstructMethods + " constructors annotated with @Initializer for " + this.getType()));
        if (postConstructMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one post construct method annotated with @PostConstruct for " + this.getType());
        }
        if (postConstructMethods.size() == 1) {
            this.postConstruct = postConstructMethods.iterator().next();
            log.trace((Object)("Exactly one post construct method (" + this.postConstruct + ") for " + this.getType()));
            return;
        }
    }

    protected void initPreDestroy() {
        Set<AnnotatedMethod<?>> preDestroyMethods = this.getAnnotatedItem().getAnnotatedMethods(PreDestroy.class);
        log.trace((Object)("Found " + preDestroyMethods + " constructors annotated with @Initializer for " + this.getType()));
        if (preDestroyMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one pre destroy method annotated with @PreDestroy for " + this.getType());
        }
        if (preDestroyMethods.size() == 1) {
            this.preDestroy = preDestroyMethods.iterator().next();
            log.trace((Object)("Exactly one post construct method (" + this.preDestroy + ") for " + this.getType()));
            return;
        }
    }

    public AnnotatedConstructor<T> getConstructor() {
        return this.constructor;
    }

    public AnnotatedMethod<?> getPostConstruct() {
        return this.postConstruct;
    }

    public AnnotatedMethod<?> getPreDestroy() {
        return this.preDestroy;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScopeType()));
        if (this.getName() == null) {
            buffer.append("unnamed simple bean");
        } else {
            buffer.append("simple bean '" + this.getName() + "'");
        }
        buffer.append(" ").append(this.getType().getName()).append(", ");
        buffer.append(" API types = ").append(Names.typesToString(this.getTypes())).append(", binding types = " + Names.annotationsToString(this.getBindings()));
        return buffer.toString();
    }

    @Override
    public SimpleBean<?> getSpecializedBean() {
        return this.specializedBean;
    }
}

