/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.annotation.FastInfoset;
import org.jboss.ws.annotation.JsonEncoding;
import org.jboss.ws.annotation.SchemaValidation;
import org.jboss.ws.extensions.addressing.jaxws.WSAddressingServerHandler;
import org.jboss.ws.feature.FastInfosetFeature;
import org.jboss.ws.feature.JsonEncodingFeature;
import org.jboss.ws.feature.SchemaValidationFeature;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointFeatureProcessor {
    private static final Logger log = Logger.getLogger(EndpointFeatureProcessor.class);

    protected void processEndpointFeatures(Deployment dep, ServerEndpointMetaData sepMetaData, Class<?> sepClass) {
        for (Annotation an : sepClass.getAnnotations()) {
            Object feature;
            Object anFeature;
            WebServiceFeatureAnnotation wsfa = an.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
            if (wsfa == null) continue;
            if (an.annotationType() == Addressing.class) {
                anFeature = sepClass.getAnnotation(Addressing.class);
                feature = new AddressingFeature(anFeature.enabled(), anFeature.required());
                sepMetaData.addFeature((WebServiceFeature)feature);
                continue;
            }
            if (an.annotationType() == MTOM.class) {
                anFeature = sepClass.getAnnotation(MTOM.class);
                feature = new MTOMFeature(anFeature.enabled(), anFeature.threshold());
                sepMetaData.addFeature((WebServiceFeature)feature);
                continue;
            }
            if (an.annotationType() == SchemaValidation.class) {
                this.processSchemaValidation(dep, sepMetaData, sepClass);
                continue;
            }
            if (an.annotationType() == FastInfoset.class) {
                anFeature = sepClass.getAnnotation(FastInfoset.class);
                feature = new FastInfosetFeature(anFeature.enabled());
                sepMetaData.addFeature((WebServiceFeature)feature);
                continue;
            }
            if (an.annotationType() == JsonEncoding.class) {
                anFeature = sepClass.getAnnotation(JsonEncoding.class);
                feature = new JsonEncodingFeature(anFeature.enabled());
                sepMetaData.addFeature((WebServiceFeature)feature);
                continue;
            }
            if (an.annotationType() == RespectBinding.class) {
                anFeature = sepClass.getAnnotation(RespectBinding.class);
                feature = new RespectBindingFeature(anFeature.enabled());
                sepMetaData.addFeature((WebServiceFeature)feature);
                continue;
            }
            throw new WebServiceException("Unsupported feature: " + wsfa.bean());
        }
    }

    protected void setupEndpointFeatures(ServerEndpointMetaData sepMetaData) {
        EndpointFeatureProcessor.setupAddressingFeature(sepMetaData);
        EndpointFeatureProcessor.setupMTOMFeature(sepMetaData);
        EndpointFeatureProcessor.setupRespectBindingFeature(sepMetaData);
    }

    private static void setupAddressingFeature(ServerEndpointMetaData sepMetaData) {
        AddressingFeature addressingFeature = sepMetaData.getFeature(AddressingFeature.class);
        if (addressingFeature != null && addressingFeature.isEnabled()) {
            log.debug((Object)"AddressingFeature found, installing WS-Addressing post-handler");
            HandlerMetaDataJAXWS hmd = new HandlerMetaDataJAXWS(UnifiedHandlerMetaData.HandlerType.POST);
            hmd.setEndpointMetaData(sepMetaData);
            hmd.setHandlerClassName(WSAddressingServerHandler.class.getName());
            hmd.setHandlerName("WSAddressing Handler");
            hmd.setProtocolBindings("##SOAP11_HTTP ##SOAP12_HTTP ##SOAP11_HTTP_MTOM ##SOAP12_HTTP_MTOM");
            sepMetaData.addHandler(hmd);
        }
    }

    private static void setupMTOMFeature(ServerEndpointMetaData sepMetaData) {
        MTOMFeature mtomFeature = sepMetaData.getFeature(MTOMFeature.class);
        if (mtomFeature != null && mtomFeature.isEnabled()) {
            String bindingId = sepMetaData.getBindingId();
            if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingId)) {
                log.debug((Object)"MTOMFeature found, setting binding to http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
                sepMetaData.setBindingId("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
            } else if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingId)) {
                log.debug((Object)"MTOMFeature found, setting binding to http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
                sepMetaData.setBindingId("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
            }
        }
    }

    private static void setupRespectBindingFeature(ServerEndpointMetaData sepMetaData) {
        RespectBindingFeature respectBindingFeature = sepMetaData.getFeature(RespectBindingFeature.class);
        if (respectBindingFeature != null && respectBindingFeature.isEnabled()) {
            log.debug((Object)"RespectBindingFeature found, looking for required not understood extensibility elements...");
            ServiceMetaData serviceMetaData = sepMetaData.getServiceMetaData();
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            WSDLService wsdlService = wsdlDefinitions.getService(serviceMetaData.getServiceName());
            if (wsdlService != null) {
                WSDLEndpoint wsdlEndpoint = wsdlService.getEndpoint(sepMetaData.getPortName());
                if (wsdlEndpoint != null) {
                    EndpointFeatureProcessor.checkNotUnderstoodExtElements(wsdlEndpoint, sepMetaData);
                    WSDLBinding wsdlBinding = wsdlDefinitions.getBinding(wsdlEndpoint.getBinding());
                    EndpointFeatureProcessor.checkNotUnderstoodExtElements(wsdlBinding, sepMetaData);
                } else {
                    log.warn((Object)("Cannot find port " + sepMetaData.getPortName()));
                }
            }
        }
    }

    private static void checkNotUnderstoodExtElements(Extendable extendable, ServerEndpointMetaData sepMetaData) {
        List<WSDLExtensibilityElement> notUnderstoodList = extendable.getNotUnderstoodExtElements();
        for (WSDLExtensibilityElement el : notUnderstoodList) {
            boolean disabledByFeature = false;
            if (!el.isRequired() || disabledByFeature) continue;
            String s = DOMWriter.printNode((Node)el.getElement(), (boolean)true);
            throw new WebServiceException("RespectBindingFeature enabled and a required not understood element was found: " + s);
        }
    }

    private void processSchemaValidation(Deployment dep, ServerEndpointMetaData sepMetaData, Class<?> sepClass) {
        Class handlerClass;
        SchemaValidation anFeature = sepClass.getAnnotation(SchemaValidation.class);
        SchemaValidationFeature feature = new SchemaValidationFeature(anFeature.enabled());
        String xsdLoc = anFeature.schemaLocation();
        if (xsdLoc.length() > 0) {
            if (dep instanceof ArchiveDeployment) {
                try {
                    URL xsdURL = ((ArchiveDeployment)dep).getMetaDataFileURL(xsdLoc);
                    xsdLoc = xsdURL.toExternalForm();
                }
                catch (IOException ex) {
                    throw new WSException("Cannot load schema: " + xsdLoc, ex);
                }
            }
            feature.setSchemaLocation(xsdLoc);
        }
        if ((handlerClass = anFeature.errorHandler()) != null) {
            try {
                ErrorHandler errorHandler = (ErrorHandler)handlerClass.newInstance();
                feature.setErrorHandler(errorHandler);
            }
            catch (Exception ex) {
                throw new WSException("Cannot instanciate error handler: " + handlerClass, ex);
            }
        }
        sepMetaData.addFeature(feature);
    }
}

