/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.platform.content.yum.Content;
import org.rhq.plugins.platform.content.yum.Package;
import org.rhq.plugins.platform.content.yum.Primary;
import org.rhq.plugins.platform.content.yum.Repomd;
import org.rhq.plugins.platform.content.yum.YumContext;
import org.rhq.plugins.platform.content.yum.YumServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Request {
    final YumServer server;
    private final Socket socket;
    private final Repomd repomd;
    private final Primary primary;
    String filename;
    Map<String, String> args;
    Map<String, String> fields;
    private final Log log = LogFactory.getLog(Request.class);

    Request(YumServer server, Socket socket) {
        this.server = server;
        this.socket = socket;
        this.repomd = new Repomd(this);
        this.primary = new Primary(this);
    }

    YumContext context() {
        return this.server.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            String request = reader.readLine();
            if (request != null) {
                StringTokenizer st = new StringTokenizer(request);
                st.nextToken();
                String url = st.nextToken();
                this.log.info((Object)("processing: " + url));
                String path = url.substring(this.context().basepath().length() + 1);
                int qmark = this.qmark(path);
                this.filename = path.substring(0, qmark);
                this.args = this.getArgs(path.substring(qmark));
                this.fields = this.httpFields(reader);
                this.reply();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"request failed:", (Throwable)e);
        }
        finally {
            this.close(this.socket);
        }
    }

    void cleanMetadata() {
        this.repomd.delete();
        this.primary.delete();
    }

    private int qmark(String path) {
        int qmark = path.indexOf(63);
        return qmark == -1 ? path.length() : qmark;
    }

    private Map<String, String> getArgs(String path) {
        if (path.length() < 4) {
            return Collections.emptyMap();
        }
        path = path.substring(1);
        HashMap<String, String> result = new HashMap<String, String>();
        for (String arg : path.split(",")) {
            int eq = arg.indexOf("=");
            String name = arg.substring(0, eq);
            String value = arg.substring(eq + 1);
            result.put(name.trim(), value.trim());
        }
        return result;
    }

    private void reply() throws Exception {
        Content content = this.selectContent(this.filename);
        if (content == null) {
            content = new Package(this);
        }
        OutputStream ostr = this.socket.getOutputStream();
        content.writeHeader(ostr);
        content.writeContent(ostr);
        ostr.close();
    }

    private Content selectContent(String filename) {
        if (filename.equals("repodata/repomd.xml")) {
            this.repomd.delete();
            if (this.primary.stale()) {
                this.primary.delete();
            }
            return this.repomd;
        }
        if (filename.equals("repodata/primary.xml")) {
            return this.primary;
        }
        return null;
    }

    private Map<String, String> httpFields(BufferedReader reader) throws Exception {
        String line;
        HashMap<String, String> result = new HashMap<String, String>();
        while ((line = reader.readLine()) != null && line.length() > 0) {
            String[] pair = line.split(":");
            result.put(pair[0], pair[1].trim());
        }
        return result;
    }

    void close(Socket socket) {
        try {
            socket.close();
        }
        catch (Exception e) {
            this.log.error((Object)"close", (Throwable)e);
        }
    }
}

