/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;

@DiscriminatorValue(value="SUBJECT")
@Entity
@NamedQueries(value={@NamedQuery(name="SubjectNotification.findAllByAlertDefinitionId", query="SELECT sn   FROM SubjectNotification sn  WHERE sn.alertDefinition.id = :alertDefinitionId "), @NamedQuery(name="SubjectNotification.findByIds", query="SELECT sn   FROM SubjectNotification sn  WHERE sn.id IN ( :ids )"), @NamedQuery(name="SubjectNotification.findBySubjectIds", query="SELECT sn   FROM SubjectNotification sn  WHERE sn.subject.id IN ( :ids )")})
public class SubjectNotification
extends AlertNotification {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL_BY_ALERT_DEFINITION_ID = "SubjectNotification.findAllByAlertDefinitionId";
    public static final String QUERY_FIND_BY_IDS = "SubjectNotification.findByIds";
    public static final String QUERY_FIND_BY_SUBJECT_IDS = "SubjectNotification.findBySubjectIds";
    @JoinColumn(name="SUBJECT_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne
    private Subject subject;

    protected SubjectNotification() {
    }

    public SubjectNotification(SubjectNotification subjectNotification) {
        this(subjectNotification.getAlertDefinition(), subjectNotification.subject);
    }

    public SubjectNotification(@NotNull AlertDefinition alertDefinition, @NotNull Subject subject) {
        super(alertDefinition);
        if (subject == null) {
            throw new IllegalArgumentException("subject must be non-null.");
        }
        this.subject = subject;
    }

    @NotNull
    public Subject getSubject() {
        return this.subject;
    }

    public AlertNotification copy() {
        return new SubjectNotification(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubjectNotification)) {
            return false;
        }
        SubjectNotification other = (SubjectNotification)obj;
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "id=" + this.getId() + ", " + "subject=" + this.subject + ", " + "]";
    }
}

