/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.vfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.plugins.context.vfs.Assembled;
import org.jboss.virtual.plugins.context.vfs.AssembledUrlStreamHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Assembled
public class ByteArrayHandler
extends AbstractVirtualFileHandler {
    private byte[] bytes;
    private final long lastModified;

    public ByteArrayHandler(VFSContext context, VirtualFileHandler parent, String name, byte[] bytes) throws IOException {
        super(context, parent, name);
        this.bytes = bytes;
        this.lastModified = System.currentTimeMillis();
        String path = this.getPathName();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.setVfsUrl(new URL("vfs", context.getName(), -1, path, new AssembledUrlStreamHandler(context)));
    }

    @Override
    public URL toURL() throws MalformedURLException, URISyntaxException {
        return this.getVfsUrl();
    }

    @Override
    public URI toURI() throws URISyntaxException {
        return this.getVfsUrl().toURI();
    }

    @Override
    public long getLastModified() throws IOException {
        return this.lastModified;
    }

    @Override
    public long getSize() throws IOException {
        return this.bytes.length;
    }

    @Override
    public boolean exists() throws IOException {
        return true;
    }

    @Override
    public boolean isLeaf() throws IOException {
        return true;
    }

    @Override
    public boolean isHidden() throws IOException {
        return false;
    }

    @Override
    public boolean isNested() throws IOException {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        throw new IOException("File cannot have children");
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        throw new IOException("File cannot have children");
    }

    @Override
    public boolean removeChild(String name) {
        return false;
    }
}

