/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.MBeanNotificationCache;
import org.jboss.mx.remoting.MBeanServerClientInvokerProxy;
import org.jboss.mx.remoting.MBeanTransportPreference;
import org.jboss.mx.remoting.NotificationQueue;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.invocation.NameBasedInvocation;

public class JMXSubsystemInvocationHandler
implements ServerInvocationHandler {
    private static final Logger log = Logger.getLogger(JMXSubsystemInvocationHandler.class);
    private MBeanServer server;
    private MBeanNotificationCache notificationCache;
    private ServerInvoker invoker;
    private Identity identity;
    private static Method getObjectInstance;
    private static Method isRegistered;
    private static Method getAttribute;
    private static Method getAttributes;
    private static Method setAttribute;
    private static Method setAttributes;
    private static Method invoke;
    private static Method getMBeanInfo;

    public void setInvoker(ServerInvoker invoker) {
        this.invoker = invoker;
    }

    public void setMBeanServer(MBeanServer server) {
        this.server = server;
        this.identity = Identity.get((MBeanServer)server);
        MBeanTransportPreference.setLocalServer(server, this.identity);
        if (log.isTraceEnabled()) {
            log.trace((Object)("setMBeanServer called with: " + server + " with identity: " + this.identity));
        }
    }

    public synchronized void destroy() {
        if (this.notificationCache != null) {
            this.notificationCache.destroy();
            this.notificationCache = null;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    private void storeNotifications(String sessionId, Map payload) {
        NotificationQueue q;
        NotificationQueue notificationQueue = q = this.notificationCache == null ? null : this.notificationCache.getNotifications(sessionId);
        if (q != null) {
            payload.put("notifications", q);
        }
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        if (this.server == null) {
            throw new IllegalStateException("invoke called prior to mbean server being set");
        }
        try {
            NameBasedInvocation nbi = (NameBasedInvocation)invocation.getParameter();
            String methodName = nbi.getMethodName();
            Object[] args = nbi.getParameters();
            String[] signature = nbi.getSignature();
            String sessionId = invocation.getSessionId();
            if (methodName.equals("$GetNotifications$")) {
                Boolean bl = new Boolean(true);
                return bl;
            }
            if (methodName.equals("$NOTIFICATIONS$")) {
                NotificationQueue queue = (NotificationQueue)args[0];
                MBeanServerClientInvokerProxy p = MBeanServerClientInvokerProxy.get(queue.getSessionID());
                if (p != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("received remote notifications for JMX id: " + queue.getSessionID() + ", queue: " + queue));
                    }
                    p.deliverNotifications(queue, true);
                } else {
                    log.warn((Object)("couldn't find a client invoker proxy for mbean serverid: " + queue.getSessionID() + ", dropping notifications [" + queue + "]"));
                }
                Object var9_15 = null;
                return var9_15;
            }
            if (methodName.equals("addNotificationListener") && signature.length == 4) {
                this.handleAddNotificationListener(invocation.getLocator(), sessionId, (ObjectName)args[0], (NotificationFilter)args[2], args[3]);
                Object queue = null;
                return queue;
            }
            if (methodName.equals("removeNotificationListener") && signature.length == 3) {
                this.handleRemoveNotificationListener(invocation.getLocator(), sessionId, (ObjectName)args[0], args[2]);
                Object queue = null;
                return queue;
            }
            Object[] _args = args == null && signature != null ? new Object[signature.length] : args;
            Method method = this.getMethod(methodName, signature);
            Object object = method.invoke((Object)this.server, _args);
            return object;
        }
        catch (Throwable ex) {
            if (ex instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException ut = (UndeclaredThrowableException)ex;
                Throwable ute = ut.getUndeclaredThrowable();
                if (ute instanceof Exception) {
                    throw new MBeanException((Exception)ute, ut.getUndeclaredThrowable().getMessage());
                }
                throw new MBeanException(new Exception(ute.getMessage()), ute.getMessage());
            }
            if (ex instanceof InvocationTargetException) {
                throw ((InvocationTargetException)ex).getTargetException();
            }
            throw ex;
        }
        finally {
            if (this.notificationCache != null) {
                this.storeNotifications(invocation.getSessionId(), invocation.getReturnPayload());
            }
        }
    }

    private synchronized void handleAddNotificationListener(InvokerLocator locator, String sessionId, ObjectName objName, NotificationFilter filter, Object handback) throws Throwable {
        if (this.notificationCache == null) {
            this.notificationCache = new MBeanNotificationCache(this.invoker, this.server);
        }
        this.notificationCache.addNotificationListener(locator, sessionId, objName, filter, handback);
    }

    private synchronized void handleRemoveNotificationListener(InvokerLocator locator, String sessionId, ObjectName objName, Object key) throws Throwable {
        if (this.notificationCache == null) {
            return;
        }
        this.notificationCache.removeNotificationListener(locator, sessionId, objName, key);
    }

    private Method getMethod(String methodName, String[] sig) throws Throwable {
        if (methodName.equals("invoke")) {
            return invoke;
        }
        if (methodName.equals("getAttribute")) {
            return getAttribute;
        }
        if (methodName.equals("setAttribute")) {
            return setAttribute;
        }
        if (methodName.equals("getAttributes")) {
            return getAttributes;
        }
        if (methodName.equals("setAttributes")) {
            return setAttributes;
        }
        if (methodName.equals("setAttributes")) {
            return setAttributes;
        }
        if (methodName.equals("getMBeanInfo")) {
            return getMBeanInfo;
        }
        if (methodName.equals("getObjectInstance")) {
            return getObjectInstance;
        }
        if (methodName.equals("isRegistered")) {
            return isRegistered;
        }
        Class[] params = null;
        if (sig != null) {
            params = new Class[sig.length];
            for (int i = 0; i < sig.length; ++i) {
                params[i] = Class.forName(sig[i]);
            }
        }
        return MBeanServer.class.getMethod(methodName, params);
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
    }

    static {
        try {
            Class<?> LObject = new Object[0].getClass();
            Class<?> LString = new String[0].getClass();
            Class[] Sig_ObjectName = new Class[]{ObjectName.class};
            Class[] Sig_ObjectName_String = new Class[]{ObjectName.class, String.class};
            Class[] Sig_ObjectName_LString = new Class[]{ObjectName.class, LString};
            Class[] Sig_ObjectName_Attribute = new Class[]{ObjectName.class, Attribute.class};
            Class[] Sig_ObjectName_AttributeList = new Class[]{ObjectName.class, AttributeList.class};
            Class[] Sig_ObjectName_String_LObject_LString = new Class[]{ObjectName.class, String.class, LObject, LString};
            getObjectInstance = MBeanServer.class.getMethod("getObjectInstance", Sig_ObjectName);
            isRegistered = MBeanServer.class.getMethod("isRegistered", Sig_ObjectName);
            getAttribute = MBeanServer.class.getMethod("getAttribute", Sig_ObjectName_String);
            getAttributes = MBeanServer.class.getMethod("getAttributes", Sig_ObjectName_LString);
            setAttribute = MBeanServer.class.getMethod("setAttribute", Sig_ObjectName_Attribute);
            setAttributes = MBeanServer.class.getMethod("setAttributes", Sig_ObjectName_AttributeList);
            invoke = MBeanServer.class.getMethod("invoke", Sig_ObjectName_String_LObject_LString);
            getMBeanInfo = MBeanServer.class.getMethod("getMBeanInfo", Sig_ObjectName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error resolving methods", e);
        }
    }
}

