/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.xml.ws.Holder;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.util.Streams;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.OpaqueStateString;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateEvent;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.InstanceContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.consumer.InvocationHandler;
import org.gatein.wsrp.consumer.RequestContextWrapper;
import org.gatein.wsrp.consumer.RequestPrecursor;
import org.gatein.wsrp.consumer.WSRPConsumerImpl;
import org.oasis.wsrp.v1.BlockingInteractionResponse;
import org.oasis.wsrp.v1.InteractionParams;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.NamedString;
import org.oasis.wsrp.v1.PerformBlockingInteraction;
import org.oasis.wsrp.v1.PortletContext;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.StateChange;
import org.oasis.wsrp.v1.UpdateResponse;
import org.oasis.wsrp.v1.UploadContext;
import org.oasis.wsrp.v1.UserContext;

public class ActionHandler
extends InvocationHandler {
    public ActionHandler(WSRPConsumerImpl consumer) {
        super(consumer);
    }

    protected Object prepareRequest(RequestPrecursor requestPrecursor, PortletInvocation invocation) {
        String state;
        if (!(invocation instanceof ActionInvocation)) {
            throw new IllegalArgumentException("ActionHandler can only handle ActionInvocations!");
        }
        ActionInvocation actionInvocation = (ActionInvocation)invocation;
        PortletContext portletContext = requestPrecursor.getPortletContext();
        log.debug("Consumer about to attempt action on portlet '" + portletContext.getPortletHandle() + "'");
        InstanceContext instanceContext = invocation.getInstanceContext();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)instanceContext, (String)"instance context");
        AccessMode accessMode = instanceContext.getAccessMode();
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)accessMode, (String)"access mode");
        log.debug("Portlet is requesting " + accessMode + " access mode");
        InteractionParams interactionParams = WSRPTypeFactory.createInteractionParams((StateChange)WSRPUtils.getStateChangeFromAccessMode((AccessMode)accessMode));
        StateString interactionState = actionInvocation.getInteractionState();
        if (interactionState != null && !"JBPNS_".equals(state = interactionState.getStringValue())) {
            interactionParams.setInteractionState(state);
        }
        RequestContextWrapper requestContext = new RequestContextWrapper(actionInvocation.getRequestContext());
        try {
            if (FileUpload.isMultipartContent((RequestContext)requestContext)) {
                FileUpload upload = new FileUpload();
                FileItemIterator iter = upload.getItemIterator((RequestContext)requestContext);
                ArrayList<UploadContext> uploadContexts = new ArrayList<UploadContext>(7);
                ArrayList<NamedString> formParameters = new ArrayList<NamedString>(7);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    InputStream stream = item.openStream();
                    if (!item.isFormField()) {
                        String contentType = item.getContentType();
                        log.debug("File field " + item.getFieldName() + " with file name " + item.getName() + " and content type " + contentType + " detected.");
                        BufferedInputStream bufIn = new BufferedInputStream(stream);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        BufferedOutputStream bos = new BufferedOutputStream(baos);
                        int c = bufIn.read();
                        while (c != -1) {
                            bos.write(c);
                            c = bufIn.read();
                        }
                        bos.flush();
                        baos.flush();
                        bufIn.close();
                        bos.close();
                        UploadContext uploadContext = WSRPTypeFactory.createUploadContext((String)contentType, (byte[])baos.toByteArray());
                        ArrayList<NamedString> mimeAttributes = new ArrayList<NamedString>(2);
                        NamedString mimeAttribute = new NamedString();
                        mimeAttribute.setName("Content-disposition");
                        mimeAttribute.setValue("form-data; name=\"" + item.getFieldName() + "\";" + " filename=\"" + item.getName() + "\"");
                        mimeAttributes.add(mimeAttribute);
                        mimeAttribute = new NamedString();
                        mimeAttribute.setName("Content-type");
                        mimeAttribute.setValue(item.getContentType());
                        mimeAttributes.add(mimeAttribute);
                        uploadContext.getMimeAttributes().addAll(mimeAttributes);
                        uploadContexts.add(uploadContext);
                        continue;
                    }
                    NamedString formParameter = new NamedString();
                    formParameter.setName(item.getFieldName());
                    formParameter.setValue(Streams.asString((InputStream)stream));
                    formParameters.add(formParameter);
                }
                interactionParams.getUploadContexts().addAll(uploadContexts);
                interactionParams.getFormParameters().addAll(formParameters);
            } else {
                Map params = actionInvocation.getForm();
                if (params != null && !params.isEmpty()) {
                    int capacity = params.size();
                    ArrayList<NamedString> formParameters = new ArrayList<NamedString>(capacity);
                    for (Map.Entry param : params.entrySet()) {
                        String name = (String)param.getKey();
                        String[] values = (String[])param.getValue();
                        NamedString formParameter = new NamedString();
                        for (String value : values) {
                            formParameter.setName(name);
                            formParameter.setValue(value);
                            formParameters.add(formParameter);
                        }
                    }
                    interactionParams.getFormParameters().addAll(formParameters);
                }
            }
        }
        catch (Exception e) {
            log.debug("Couldn't create UploadContext", (Throwable)e);
        }
        log.debug(WSRPUtils.toString((InteractionParams)interactionParams));
        return WSRPTypeFactory.createPerformBlockingInteraction((PortletContext)portletContext, (RuntimeContext)requestPrecursor.runtimeContext, (MarkupParams)requestPrecursor.markupParams, (InteractionParams)interactionParams);
    }

    protected PortletInvocationResponse processResponse(Object response, PortletInvocation invocation, RequestPrecursor requestPrecursor) throws PortletInvokerException {
        PortletContext portletContext;
        String navigationalState;
        String newWindowState;
        BlockingInteractionResponse blockingInteractionResponse = (BlockingInteractionResponse)response;
        log.debug("Starting processing response");
        String redirectURL = blockingInteractionResponse.getRedirectURL();
        UpdateResponse updateResponse = blockingInteractionResponse.getUpdateResponse();
        if (redirectURL != null && updateResponse != null) {
            return new ErrorResponse((Throwable)new IllegalArgumentException("Response cannot both redirect and update state."));
        }
        if (redirectURL != null) {
            return new HTTPRedirectionResponse(redirectURL);
        }
        UpdateNavigationalStateResponse result = new UpdateNavigationalStateResponse();
        String newMode = updateResponse.getNewMode();
        if (newMode != null) {
            result.setMode(WSRPUtils.getJSR168PortletModeFromWSRPName((String)newMode));
        }
        if ((newWindowState = updateResponse.getNewWindowState()) != null) {
            result.setWindowState(WSRPUtils.getJSR168WindowStateFromWSRPName((String)newWindowState));
        }
        if ((navigationalState = updateResponse.getNavigationalState()) != null) {
            result.setNavigationalState((StateString)new OpaqueStateString(navigationalState));
        }
        if ((portletContext = updateResponse.getPortletContext()) != null) {
            PortletContext originalContext = requestPrecursor.getPortletContext();
            InstanceContext context = invocation.getInstanceContext();
            String handle = portletContext.getPortletHandle();
            if (!originalContext.getPortletHandle().equals(handle)) {
                log.debug("Portlet '" + requestPrecursor.getPortletHandle() + "' was implicitely cloned. New handle is '" + handle + "'");
                StateEvent event = new StateEvent(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext), StateEvent.Type.PORTLET_CLONED_EVENT);
                context.onStateEvent(event);
            } else {
                byte[] newState;
                byte[] originalState = originalContext.getPortletState();
                if (!Arrays.equals(originalState, newState = portletContext.getPortletState())) {
                    StateEvent event = new StateEvent(WSRPUtils.convertToPortalPortletContext((PortletContext)portletContext), StateEvent.Type.PORTLET_MODIFIED_EVENT);
                    context.onStateEvent(event);
                }
            }
            this.consumer.getSessionHandler().updateSessionInfoFor(originalContext.getPortletHandle(), handle, invocation);
        } else {
            portletContext = requestPrecursor.getPortletContext();
        }
        this.consumer.getSessionHandler().updateSessionIfNeeded(updateResponse.getSessionContext(), invocation, portletContext.getPortletHandle());
        log.debug("Response processed");
        return result;
    }

    protected void updateUserContext(Object request, UserContext userContext) {
        this.getActionRequest(request).setUserContext(userContext);
    }

    protected void updateRegistrationContext(Object request) throws PortletInvokerException {
        this.getActionRequest(request).setRegistrationContext(this.consumer.getRegistrationContext());
    }

    protected RuntimeContext getRuntimeContextFrom(Object request) {
        return this.getActionRequest(request).getRuntimeContext();
    }

    protected Object performRequest(Object request) throws Exception {
        PerformBlockingInteraction interaction = this.getActionRequest(request);
        Holder updateResponseHolder = new Holder();
        Holder redirectURL = new Holder();
        log.debug("performBlockingInteraction on '" + interaction.getPortletContext().getPortletHandle() + "'");
        this.consumer.getMarkupService().performBlockingInteraction(interaction.getRegistrationContext(), interaction.getPortletContext(), interaction.getRuntimeContext(), interaction.getUserContext(), interaction.getMarkupParams(), interaction.getInteractionParams(), updateResponseHolder, redirectURL, new Holder());
        BlockingInteractionResponse response = new BlockingInteractionResponse();
        response.setRedirectURL((String)redirectURL.value);
        response.setUpdateResponse((UpdateResponse)updateResponseHolder.value);
        return response;
    }

    private PerformBlockingInteraction getActionRequest(Object request) {
        if (request instanceof PerformBlockingInteraction) {
            return (PerformBlockingInteraction)request;
        }
        throw new IllegalArgumentException("ActionHandler: request is not a PerformBlockingInteraction request!");
    }
}

