/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.helpers;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.servlet.ServletConfig;
import org.jboss.console.manager.PluginManager;
import org.jboss.console.manager.interfaces.ConsolePlugin;
import org.jboss.console.manager.interfaces.ManageableResource;
import org.jboss.console.manager.interfaces.ResourceTreeNode;
import org.jboss.console.manager.interfaces.TreeNode;
import org.jboss.console.manager.interfaces.TreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.manager.interfaces.impl.MBeanResource;
import org.jboss.console.manager.interfaces.impl.SeparatorTreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.impl.SimpleFolderResource;
import org.jboss.console.manager.interfaces.impl.SimpleResourceTreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNode;
import org.jboss.console.manager.interfaces.impl.SimpleTreeNodeMenuEntryImpl;
import org.jboss.console.plugins.helpers.PluginWrapper;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.Registry;

public abstract class AbstractPluginWrapper
implements PluginWrapper,
ConsolePlugin {
    public static final String OBJECT_NAME_PARAM = "ObjectName";
    public static final String FOLDER_NAME_PARAM = "FolderName";
    public static final String MBEAN_CLASS_PARAM = "MBeanClass";
    public static final String WRAPPER_CLASS_PARAM = "WrapperClass";
    public static final String SCRIPT_NAME_PARAM = "ScriptName";
    public static final String IS_ROOT_NODE_PARAM = "IsRootNode";
    protected MBeanServer mbeanServer = null;
    protected PluginManager pm = null;
    protected String pluginName = null;
    protected String pluginVersion = null;
    protected String objectName = null;
    protected String mbeanClass = null;
    protected String folderName = null;
    protected String rootContextName = null;
    protected Logger log = Logger.getLogger(this.getClass());
    protected InternalResourceChecker checker = null;

    public void init(ServletConfig servletConfig) throws Exception {
        this.findJBossMBeanServer();
        this.findPluginManager();
        this.readConfigurationParameters(servletConfig);
        this.pm.registerPlugin(this);
    }

    public void destroy() {
        if (this.pm != null) {
            this.pm.unregisterPlugin(this);
        }
    }

    public void readConfigurationParameters(ServletConfig config) {
        this.pluginName = config.getInitParameter("PluginName");
        this.pluginVersion = config.getInitParameter("PluginVersion");
        this.folderName = config.getInitParameter(FOLDER_NAME_PARAM);
        this.objectName = config.getInitParameter(OBJECT_NAME_PARAM);
        this.mbeanClass = config.getInitParameter(MBEAN_CLASS_PARAM);
        this.rootContextName = config.getInitParameter("ContextName");
        String tmp = this.objectName;
        if (tmp != null && !"".equals(tmp)) {
            this.checker = new SingleMBeanChecker();
        }
        if ((tmp = this.folderName) != null && !"".equals(tmp)) {
            this.checker = new SubFolderChecker();
        }
        if ((tmp = config.getInitParameter(IS_ROOT_NODE_PARAM)) != null && !"".equals(tmp) && "true".equalsIgnoreCase(tmp)) {
            this.checker = new RootTreeChecker();
        }
        if ((tmp = this.mbeanClass) != null && !"".equals(tmp)) {
            this.checker = new StandardMBeanChecker();
        }
    }

    public String getIdentifier() {
        if (this.pluginName != null) {
            return this.pluginName + " (Wrapped by ServletPluginHelper)";
        }
        return this.getPluginIdentifier();
    }

    public String getVersion() {
        if (this.pluginVersion != null) {
            return this.pluginVersion;
        }
        return this.getPluginVersion();
    }

    public String[] getSupportedProfiles() {
        return new String[]{"WEB"};
    }

    public TreeNode getSubTreeForResource(PluginManager master, String profile, ManageableResource resource) {
        if (!"WEB".equalsIgnoreCase(profile)) {
            return null;
        }
        if (this.isResourceToBeManaged(resource)) {
            return this.getTreeForResource(profile, resource);
        }
        return null;
    }

    protected boolean isResourceToBeManaged(ManageableResource resource) {
        if (this.checker == null) {
            return false;
        }
        return this.checker.isResourceToBeManaged(resource);
    }

    protected abstract TreeNode getTreeForResource(String var1, ManageableResource var2);

    protected String getPluginIdentifier() {
        return "AbstractPluginWrapper (" + this.getClass() + ")";
    }

    protected String getPluginVersion() {
        return "unknown version";
    }

    protected void findJBossMBeanServer() {
        this.mbeanServer = MBeanServerLocator.locateJBoss();
    }

    protected void findPluginManager() {
        this.pm = (PluginManager)Registry.lookup((Object)PluginManager.PLUGIN_MANAGER_NAME);
    }

    protected MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    protected String fixUrl(String source) {
        if (source == null) {
            return null;
        }
        if (source.toLowerCase().startsWith("http://") || source.toLowerCase().startsWith("https://")) {
            return source;
        }
        if (source.startsWith("/")) {
            return source;
        }
        return this.rootContextName + "/" + source;
    }

    protected ObjectInstance[] getMBeansForClass(String scope, String className) {
        try {
            Set<ObjectInstance> result = this.mbeanServer.queryMBeans(new ObjectName(scope), Query.eq(Query.classattr(), Query.value(className)));
            return result.toArray(new ObjectInstance[result.size()]);
        }
        catch (MalformedObjectNameException e) {
            this.log.debug(e);
            return new ObjectInstance[0];
        }
    }

    protected ObjectInstance[] getMBeansForQuery(String scope, QueryExp query) {
        try {
            Set<ObjectInstance> result = this.mbeanServer.queryMBeans(new ObjectName(scope), query);
            return result.toArray(new ObjectInstance[result.size()]);
        }
        catch (MalformedObjectNameException e) {
            this.log.debug(e);
            return new ObjectInstance[0];
        }
    }

    protected SimpleTreeNode createTreeNode(String name, String description, String iconUrl, String defaultUrl, TreeNodeMenuEntry[] menuEntries, TreeNode[] subNodes, ResourceTreeNode[] subResNodes) throws Exception {
        HttpLinkTreeAction action = new HttpLinkTreeAction(this.fixUrl(defaultUrl));
        return new SimpleTreeNode(name, description, this.fixUrl(iconUrl), action, menuEntries, subNodes, subResNodes);
    }

    protected SimpleResourceTreeNode createResourceNode(String name, String description, String iconUrl, String defaultUrl, TreeNodeMenuEntry[] menuEntries, TreeNode[] subNodes, ResourceTreeNode[] subResNodes, String jmxObjectName, String jmxClassName) throws Exception {
        HttpLinkTreeAction action = new HttpLinkTreeAction(this.fixUrl(defaultUrl));
        MBeanResource res = new MBeanResource(new ObjectName(jmxObjectName), jmxClassName);
        return new SimpleResourceTreeNode(name, description, this.fixUrl(iconUrl), action, menuEntries, subNodes, subResNodes, res);
    }

    protected SimpleResourceTreeNode createResourceNode(String name, String description, String iconUrl, String defaultUrl, TreeNodeMenuEntry[] menuEntries, TreeNode[] subNodes, ResourceTreeNode[] subResNodes, ManageableResource resource) throws Exception {
        HttpLinkTreeAction action = new HttpLinkTreeAction(this.fixUrl(defaultUrl));
        return new SimpleResourceTreeNode(name, description, this.fixUrl(iconUrl), action, menuEntries, subNodes, subResNodes, resource);
    }

    protected TreeNodeMenuEntry[] createMenus(String[] content) throws Exception {
        TreeNodeMenuEntry[] menuEntries = null;
        if (content != null && content.length > 0) {
            menuEntries = new TreeNodeMenuEntry[content.length];
            int i = 0;
            while (i < content.length) {
                if (content[i] == null) {
                    menuEntries[i] = new SeparatorTreeNodeMenuEntry();
                    ++i;
                    continue;
                }
                String text = content[i];
                HttpLinkTreeAction action = new HttpLinkTreeAction(this.fixUrl(content[i + 1]));
                menuEntries[i] = new SimpleTreeNodeMenuEntryImpl(text, action);
                i += 2;
            }
        } else {
            menuEntries = new TreeNodeMenuEntry[]{};
        }
        return menuEntries;
    }

    protected String encode(String source) {
        try {
            return URLEncoder.encode(source);
        }
        catch (Exception e) {
            return source;
        }
    }

    public class SubFolderChecker
    implements InternalResourceChecker {
        public boolean isResourceToBeManaged(ManageableResource resource) {
            if (resource == null || !(resource instanceof SimpleFolderResource)) {
                return false;
            }
            return AbstractPluginWrapper.this.folderName.equals(resource.getId());
        }
    }

    public class SingleMBeanChecker
    implements InternalResourceChecker {
        public boolean isResourceToBeManaged(ManageableResource resource) {
            if (AbstractPluginWrapper.this.objectName != null && resource instanceof MBeanResource) {
                MBeanResource mbr = (MBeanResource)resource;
                return AbstractPluginWrapper.this.objectName.equals(mbr.getObjectName().toString());
            }
            return false;
        }
    }

    public class RootTreeChecker
    implements InternalResourceChecker {
        public boolean isResourceToBeManaged(ManageableResource resource) {
            if (resource == null) {
                return false;
            }
            return resource.equals(AbstractPluginWrapper.this.pm.getBootstrapResource());
        }
    }

    public class StandardMBeanChecker
    implements InternalResourceChecker {
        protected Class targetClass = null;
        public HashMap knownAnswers = new HashMap();

        public StandardMBeanChecker() {
            try {
                this.targetClass = Thread.currentThread().getContextClassLoader().loadClass(AbstractPluginWrapper.this.mbeanClass);
            }
            catch (Exception displayed) {
                displayed.printStackTrace();
            }
        }

        public boolean isResourceToBeManaged(ManageableResource resource) {
            if (resource instanceof MBeanResource) {
                MBeanResource mbr = (MBeanResource)resource;
                Boolean result = (Boolean)this.knownAnswers.get(mbr.getClassName());
                if (result == null) {
                    try {
                        Class<?> resourceClass = Thread.currentThread().getContextClassLoader().loadClass(mbr.getClassName());
                        result = new Boolean(this.targetClass.isAssignableFrom(resourceClass));
                    }
                    catch (Exception e) {
                        result = Boolean.FALSE;
                    }
                    this.knownAnswers.put(mbr.getClassName(), result);
                }
                return result;
            }
            return false;
        }
    }

    public static interface InternalResourceChecker {
        public boolean isResourceToBeManaged(ManageableResource var1);
    }
}

