/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;

@DiscriminatorColumn(name="DTYPE")
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONFIG_PROPERTY_ID_SEQ")
@Table(name="RHQ_CONFIG_PROPERTY")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@XmlSeeAlso(value={PropertySimple.class, PropertyList.class, PropertyMap.class})
public abstract class Property
implements Externalizable {
    private static final long serialVersionUID = 1L;
    @Column(name="ID")
    @GeneratedValue(generator="SEQ", strategy=GenerationType.SEQUENCE)
    @Id
    private int id;
    @JoinColumn(name="CONFIGURATION_ID", referencedColumnName="ID")
    @ManyToOne(optional=true)
    @XmlTransient
    private Configuration configuration;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="ERROR_MESSAGE", nullable=true)
    private String errorMessage;
    @JoinColumn(name="PARENT_LIST_ID", referencedColumnName="ID")
    @ManyToOne
    @XmlTransient
    private PropertyList parentList;
    @JoinColumn(name="PARENT_MAP_ID", referencedColumnName="ID")
    @ManyToOne
    @XmlTransient
    private PropertyMap parentMap;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public PropertyList getParentList() {
        return this.parentList;
    }

    public void setParentList(PropertyList parentList) {
        this.parentList = parentList;
    }

    public PropertyMap getParentMap() {
        return this.parentMap;
    }

    public void setParentMap(PropertyMap parentMap) {
        this.parentMap = parentMap;
    }

    @XmlTransient
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage != null ? errorMessage.trim() : errorMessage;
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Property)) {
            return false;
        }
        Property property = (Property)obj;
        return !(this.name != null ? !this.name.equals(property.name) : property.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.id);
        out.writeObject(this.configuration);
        out.writeUTF(this.name);
        out.writeObject(this.parentList);
        out.writeObject(this.parentMap);
        out.writeObject(this.errorMessage);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readInt();
        this.configuration = (Configuration)in.readObject();
        this.name = in.readUTF();
        this.parentList = (PropertyList)in.readObject();
        this.parentMap = (PropertyMap)in.readObject();
        this.errorMessage = (String)in.readObject();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName());
        str.append("[id=").append(this.getId());
        str.append(", name=").append(this.getName());
        this.appendToStringInternals(str);
        str.append(']');
        return str.toString();
    }

    protected void appendToStringInternals(StringBuilder str) {
    }
}

