/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.ProductVersionPackageVersionPK;
import org.rhq.core.domain.resource.ProductVersion;

@Entity
@IdClass(value=ProductVersionPackageVersionPK.class)
@NamedQueries(value={@NamedQuery(name="ProductVersionPackageVersion.deleteByPackageVersionId", query="DELETE ProductVersionPackageVersion pvpv WHERE pvpv.packageVersion.id = :packageVersionId")})
@Table(name="RHQ_PKG_PRD_MAP")
public class ProductVersionPackageVersion
implements Serializable {
    public static final String DELETE_BY_PACKAGE_VERSION_ID = "ProductVersionPackageVersion.deleteByPackageVersionId";
    private static final long serialVersionUID = 1L;
    @Id
    private ProductVersion productVersion;
    @Id
    private PackageVersion packageVersion;

    protected ProductVersionPackageVersion() {
    }

    public ProductVersionPackageVersion(ProductVersion productVersion, PackageVersion packageVersion) {
        this.productVersion = productVersion;
        this.packageVersion = packageVersion;
    }

    public ProductVersionPackageVersionPK getProductVersionPackageVersionPK() {
        return new ProductVersionPackageVersionPK(this.productVersion, this.packageVersion);
    }

    public void setProductVersionPackageVersionPK(ProductVersionPackageVersionPK pk) {
        this.productVersion = pk.getProductVersion();
        this.packageVersion = pk.getPackageVersion();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ChannelPV: ");
        str.append("prd=[").append(this.productVersion).append("]");
        str.append(", pkg=[").append(this.packageVersion).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.productVersion == null ? 0 : this.productVersion.hashCode());
        result = 31 * result + (this.packageVersion == null ? 0 : this.packageVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ProductVersionPackageVersion)) {
            return false;
        }
        ProductVersionPackageVersion other = (ProductVersionPackageVersion)obj;
        if (this.productVersion == null ? this.productVersion != null : !this.productVersion.equals(other.productVersion)) {
            return false;
        }
        return !(this.packageVersion == null ? this.packageVersion != null : !this.packageVersion.equals(other.packageVersion));
    }
}

