/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency.policy;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.classloader.plugins.loader.ClassLoaderToLoaderAdapter;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.ClassLoaderPolicyFactory;
import org.jboss.classloader.spi.ClassLoaderSystem;
import org.jboss.classloader.spi.DelegateLoader;
import org.jboss.classloader.spi.Loader;
import org.jboss.classloader.spi.ParentPolicy;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.filter.LazyFilteredDelegateLoader;
import org.jboss.classloading.spi.dependency.Domain;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.RequirementDependencyItem;
import org.jboss.classloading.spi.dependency.helpers.ClassLoadingMetaDataModule;
import org.jboss.classloading.spi.dependency.policy.DynamicClassLoaderPolicyFactory;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;

public abstract class ClassLoaderPolicyModule
extends ClassLoadingMetaDataModule {
    private static final long serialVersionUID = -3357427104777457717L;
    private ClassLoaderPolicy policy;
    private ClassLoaderSystem system;
    private ClassLoader classLoader;

    public ClassLoaderPolicyModule(ClassLoadingMetaData classLoadingMetaData, String contextName) {
        super(classLoadingMetaData, contextName);
    }

    protected ClassLoader getClassLoaderForClass(final String className) throws ClassNotFoundException {
        if (this.classLoader == null) {
            throw new IllegalStateException("No classloader for module " + this);
        }
        if (!(this.classLoader instanceof BaseClassLoader)) {
            return super.getClassLoaderForClass(className);
        }
        final BaseClassLoader bcl = (BaseClassLoader)this.classLoader;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return bcl.findClassLoader(className);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException("Error during findClassLoader for " + className, e);
            }
        }
        return bcl.findClassLoader(className);
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderSystem system) {
        if (system == null) {
            throw new IllegalArgumentException("Null classloader system");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Module " + this + " is not registered, see previous error messages");
        }
        String domainName = this.getDeterminedDomainName();
        ParentPolicy parentPolicy = this.getDeterminedParentPolicy();
        String parentName = this.getDeterminedParentDomainName();
        ClassLoader result = system.registerClassLoaderPolicy(domainName, parentPolicy, parentName, this.getPolicy());
        this.system = system;
        this.classLoader = result;
        ClassLoaderPolicyModule.registerModuleClassLoader(this, result);
        return result;
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderSystem system, ClassLoader parent) {
        ClassLoader result;
        if (system == null) {
            throw new IllegalArgumentException("Null classloader system");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Module " + this + " is not registered, see previous error messages");
        }
        ClassLoaderToLoaderAdapter loader = new ClassLoaderToLoaderAdapter(parent);
        this.classLoader = result = this.registerClassLoaderPolicy(system, (Loader)loader);
        ClassLoaderPolicyModule.registerModuleClassLoader(this, result);
        return result;
    }

    public ClassLoader registerClassLoaderPolicy(ClassLoaderSystem system, Loader loader) {
        if (system == null) {
            throw new IllegalArgumentException("Null classloader system");
        }
        if (!this.isValid()) {
            throw new IllegalStateException("Module " + this + " is not registered, see previous error messages");
        }
        String domainName = this.getDeterminedDomainName();
        ParentPolicy parentPolicy = this.getDeterminedParentPolicy();
        ClassLoader result = system.registerClassLoaderPolicy(domainName, parentPolicy, loader, this.getPolicy());
        this.system = system;
        this.classLoader = result;
        ClassLoaderPolicyModule.registerModuleClassLoader(this, result);
        return result;
    }

    public ClassLoaderPolicy getPolicy() {
        if (this.policy != null) {
            return this.policy;
        }
        this.policy = this.determinePolicy();
        return this.policy;
    }

    public void removeClassLoader() {
        if (this.system != null && this.policy != null) {
            this.system.unregisterClassLoaderPolicy(this.policy);
        }
        if (this.classLoader != null) {
            ClassLoaderPolicyModule.unregisterModuleClassLoader(this, this.classLoader);
        }
        this.classLoader = null;
        this.system = null;
        this.policy = null;
    }

    protected abstract ClassLoaderPolicy determinePolicy();

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DelegateLoader createLazyDelegateLoader(Domain domain, RequirementDependencyItem item) {
        ControllerContext context = this.getControllerContext();
        if (context == null) {
            throw new IllegalStateException("No controller context");
        }
        Controller controller = context.getController();
        DynamicClassLoaderPolicyFactory factory = new DynamicClassLoaderPolicyFactory(controller, domain, item);
        return new LazyFilteredDelegateLoader((ClassLoaderPolicyFactory)factory);
    }

    public DelegateLoader getDelegateLoader(Module requiringModule, Requirement requirement) {
        return this.getPolicy().getExported();
    }

    public void reset() {
        super.reset();
        this.system = null;
        this.policy = null;
    }
}

