/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.util.Map;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.invocation.ActionInvocation;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.pc.api.spi.RequestContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.RequestProcessor;
import org.gatein.wsrp.producer.WSRPPortletInvocationContext;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.WSRPRequestContext;
import org.oasis.wsrp.v1.InteractionParams;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.PerformBlockingInteraction;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.StateChange;
import org.oasis.wsrp.v1.UnsupportedMimeType;
import org.oasis.wsrp.v1.UnsupportedMode;
import org.oasis.wsrp.v1.UnsupportedWindowState;
import org.oasis.wsrp.v1.UpdateResponse;
import org.oasis.wsrp.v1.UserContext;

class ActionRequestProcessor
extends RequestProcessor {
    private final PerformBlockingInteraction performBlockingInteraction;
    private final InteractionParams interactionParams;

    public ActionRequestProcessor(WSRPProducerImpl producer, PerformBlockingInteraction performBlockingInteraction, InteractionParams interactionParams) throws UnsupportedMimeType, UnsupportedWindowState, InvalidHandle, UnsupportedMode, MissingParameters, InvalidRegistration, OperationFailed {
        super(producer);
        this.performBlockingInteraction = performBlockingInteraction;
        this.interactionParams = interactionParams;
        this.prepareInvocation();
    }

    RegistrationContext getRegistrationContext() {
        return this.performBlockingInteraction.getRegistrationContext();
    }

    RuntimeContext getRuntimeContext() {
        return this.performBlockingInteraction.getRuntimeContext();
    }

    MarkupParams getMarkupParams() {
        return this.performBlockingInteraction.getMarkupParams();
    }

    org.oasis.wsrp.v1.PortletContext getPortletContext() {
        return this.performBlockingInteraction.getPortletContext();
    }

    UserContext getUserContext() {
        return this.performBlockingInteraction.getUserContext();
    }

    String getContextName() {
        return "PerformBlockingInteraction";
    }

    AccessMode getAccessMode() throws MissingParameters {
        StateChange stateChange = this.interactionParams.getPortletStateChange();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)stateChange, (String)"portletStateChange", (String)"InteractionParams");
        return WSRPUtils.getAccessModeFromStateChange((StateChange)stateChange);
    }

    PortletInvocation initInvocation(WSRPPortletInvocationContext context) {
        ActionInvocation invocation = new ActionInvocation((PortletInvocationContext)context);
        WSRPRequestContext requestContext = WSRPRequestContext.createRequestContext(this.markupRequest, this.interactionParams);
        invocation.setRequestContext((RequestContext)requestContext);
        StateString interactionState = this.createNavigationalState(this.interactionParams.getInteractionState());
        invocation.setInteractionState(interactionState);
        invocation.setForm((Map)requestContext.getForm());
        return invocation;
    }

    Object processResponse(PortletInvocationResponse response) {
        if (response instanceof UpdateNavigationalStateResponse) {
            UpdateNavigationalStateResponse renderResult = (UpdateNavigationalStateResponse)response;
            UpdateResponse updateResponse = WSRPTypeFactory.createUpdateResponse();
            updateResponse.setNewMode(WSRPUtils.convertJSR168PortletModeNameToWSRPName((String)this.getNewStateOrNull(renderResult, true)));
            updateResponse.setNewWindowState(WSRPUtils.convertJSR168WindowStateNameToWSRPName((String)this.getNewStateOrNull(renderResult, false)));
            StateString ns = renderResult.getNavigationalState();
            updateResponse.setNavigationalState(ns != null ? ns.getStringValue() : null);
            if (this.instanceContext.wasModified()) {
                org.oasis.wsrp.v1.PortletContext updatedPortletContext = WSRPUtils.convertToWSRPPortletContext((PortletContext)this.instanceContext.getPortletContext());
                updateResponse.setPortletContext(updatedPortletContext);
            }
            return WSRPTypeFactory.createBlockingInteractionResponse((UpdateResponse)updateResponse);
        }
        HTTPRedirectionResponse redirectionResult = (HTTPRedirectionResponse)response;
        return WSRPTypeFactory.createBlockingInteractionResponse((String)redirectionResult.getLocation());
    }

    private String getNewStateOrNull(UpdateNavigationalStateResponse renderResult, boolean forMode) {
        Mode state = forMode ? renderResult.getMode() : renderResult.getWindowState();
        return state != null ? state.toString() : null;
    }
}

