/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.WindowStateInfo;
import org.gatein.registration.Registration;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPTypeFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.ServiceDescriptionInterface;
import org.gatein.wsrp.producer.ServiceHandler;
import org.gatein.wsrp.producer.Utils;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.oasis.wsrp.v1.CookieProtocol;
import org.oasis.wsrp.v1.GetServiceDescription;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.LocalizedString;
import org.oasis.wsrp.v1.MarkupType;
import org.oasis.wsrp.v1.ModelDescription;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.PortletDescription;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.ServiceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ServiceDescriptionHandler
extends ServiceHandler
implements ServiceDescriptionInterface {
    private final CookieProtocol BEA_8_CONSUMER_FIX = CookieProtocol.PER_USER;

    ServiceDescriptionHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    @Override
    public ServiceDescription getServiceDescription(GetServiceDescription gs) throws InvalidRegistration, OperationFailed {
        List<PortletDescription> offeredPortlets;
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)gs, (String)"GetServiceDescription");
        RegistrationContext registrationContext = gs.getRegistrationContext();
        ProducerRegistrationRequirements requirements = this.producer.getProducerRegistrationRequirements();
        ServiceDescription serviceDescription = WSRPTypeFactory.createServiceDescription((boolean)requirements.isRegistrationRequired());
        serviceDescription.setRequiresInitCookie(this.BEA_8_CONSUMER_FIX);
        serviceDescription.getLocales().addAll(this.producer.getSupportedLocales());
        Registration registration = null;
        if (registrationContext != null) {
            registration = this.producer.getRegistrationOrFailIfInvalid(registrationContext);
        }
        if ((offeredPortlets = this.getPortletDescriptions(gs.getDesiredLocales(), registration)) != null) {
            serviceDescription.getOfferedPortlets().addAll(offeredPortlets);
        }
        if (registration == null && requirements.isRegistrationRequired()) {
            log.debug("Unregistered consumer while registration is required. Sending registration information.");
            Map<QName, RegistrationPropertyDescription> info = requirements.getRegistrationProperties();
            ModelDescription description = null;
            if (info != null && !info.isEmpty()) {
                description = Utils.convertRegistrationPropertiesToModelDescription(info);
            }
            serviceDescription.setRegistrationPropertyDescription(description);
        }
        return serviceDescription;
    }

    private Set<PortletDescription> getOfferedPortletDescriptions(List<String> desiredLocales) {
        Set<Portlet> portlets;
        try {
            portlets = this.producer.getRemotablePortlets();
        }
        catch (PortletInvokerException e) {
            log.warn("Could not retrieve portlets. Reason:\n\t" + e.getLocalizedMessage());
            return Collections.emptySet();
        }
        HashSet<PortletDescription> offeredPortletDescriptions = new HashSet<PortletDescription>(portlets.size());
        for (Portlet portlet : portlets) {
            PortletDescription desc = this.getPortletDescription(portlet, desiredLocales);
            offeredPortletDescriptions.add(desc);
        }
        return offeredPortletDescriptions;
    }

    public PortletDescription getPortletDescription(org.oasis.wsrp.v1.PortletContext portletContext, List<String> desiredLocales, Registration registration) throws InvalidHandle, OperationFailed {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)portletContext, (String)"portlet context");
        try {
            Portlet portlet = this.producer.getPortletWith(WSRPUtils.convertToPortalPortletContext((org.oasis.wsrp.v1.PortletContext)portletContext), registration);
            return this.getPortletDescription(portlet, desiredLocales);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)("Could not retrieve portlet '" + portletContext + "'"), (Throwable)e);
        }
    }

    private List<PortletDescription> getPortletDescriptions(List<String> desiredLocales, Registration registration) {
        ProducerRegistrationRequirements registrationReq = this.producer.getProducerRegistrationRequirements();
        if (registration == null && registrationReq.isRegistrationRequired() && registrationReq.isRegistrationRequiredForFullDescription()) {
            return null;
        }
        Set<PortletDescription> descriptions = this.getOfferedPortletDescriptions(desiredLocales);
        return new ArrayList<PortletDescription>(descriptions);
    }

    PortletDescription getPortletDescription(Portlet portlet, List<String> desiredLocales) {
        String commaSeparatedKeywords;
        PortletContext context = portlet.getContext();
        PortletInfo info = portlet.getInfo();
        log.debug("Constructing portlet description for: " + context.getId());
        CapabilitiesInfo capInfo = info.getCapabilities();
        Set allMediaTypes = capInfo.getMediaTypes();
        ArrayList<MarkupType> markupTypes = new ArrayList<MarkupType>(allMediaTypes.size());
        for (MediaType mediaType : allMediaTypes) {
            MarkupType markupType = WSRPTypeFactory.createMarkupType((String)mediaType.getValue(), this.getModeNamesFrom(capInfo.getModes(mediaType)), this.getWindowStateNamesFrom(capInfo.getWindowStates(mediaType)), this.getLocaleNamesFrom(capInfo.getLocales(mediaType)));
            markupTypes.add(markupType);
        }
        PortletDescription desc = WSRPTypeFactory.createPortletDescription((PortletContext)context, markupTypes);
        desc.setGroupID(info.getApplicationName());
        MetaInfo metaInfo = info.getMeta();
        desc.setDescription(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("description"), desiredLocales));
        desc.setShortTitle(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("short-title"), desiredLocales));
        desc.setTitle(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("title"), desiredLocales));
        desc.setDisplayName(Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("display-name"), desiredLocales));
        LocalizedString concatenatedKeywords = Utils.convertToWSRPLocalizedString(metaInfo.getMetaValue("keywords"), desiredLocales);
        if (concatenatedKeywords != null && (commaSeparatedKeywords = concatenatedKeywords.getValue()) != null && commaSeparatedKeywords.length() > 0) {
            String[] keywordArray;
            String lang = concatenatedKeywords.getLang();
            for (String keyword : keywordArray = commaSeparatedKeywords.split(",")) {
                desc.getKeywords().add(WSRPTypeFactory.createLocalizedString((String)lang, (String)concatenatedKeywords.getResourceName(), (String)keyword.trim()));
            }
        }
        return desc;
    }

    private List<String> getLocaleNamesFrom(Collection<Locale> locales) {
        if (locales == null || locales.isEmpty()) {
            return null;
        }
        ArrayList<String> localeNames = new ArrayList<String>(locales.size());
        for (Locale locale : locales) {
            localeNames.add(WSRPUtils.toString((Locale)locale));
        }
        return localeNames;
    }

    private List<String> getWindowStateNamesFrom(Collection<WindowStateInfo> windowStates) {
        ArrayList<String> result = new ArrayList<String>(windowStates.size());
        for (WindowStateInfo windowStateInfo : windowStates) {
            result.add(WSRPUtils.convertJSR168WindowStateNameToWSRPName((String)windowStateInfo.getWindowStateName()));
        }
        return result;
    }

    private List<String> getModeNamesFrom(Collection<ModeInfo> modes) {
        ArrayList<String> result = new ArrayList<String>(modes.size());
        for (ModeInfo modeInfo : modes) {
            result.add(WSRPUtils.convertJSR168PortletModeNameToWSRPName((String)modeInfo.getModeName()));
        }
        return result;
    }
}

