/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.discovery;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityReport
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String agentName;
    private List<Availability> availabilities = new ArrayList<Availability>();
    private boolean changesOnly = false;

    public AvailabilityReport() {
        this(false, "");
    }

    public AvailabilityReport(String agentName) {
        this(false, agentName);
    }

    public AvailabilityReport(boolean changesOnly, String agentName) {
        this.changesOnly = changesOnly;
        this.agentName = agentName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void addAvailability(Availability availability) {
        this.availabilities.add(availability);
    }

    public List<Availability> getResourceAvailability() {
        return this.availabilities;
    }

    public boolean isChangesOnlyReport() {
        return this.changesOnly;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeAll) {
        StringBuilder str = new StringBuilder("AV:");
        str.append('[').append(this.agentName).append(']');
        str.append('[').append(this.availabilities.size()).append(']');
        str.append('[').append(this.changesOnly ? "changesOnly" : "full").append(']');
        if (includeAll && this.availabilities.size() > 0) {
            for (Availability avail : this.availabilities) {
                str.append('\n');
                str.append("resource[").append(avail.getResource()).append(']');
                str.append(", avail[").append(avail).append(']');
            }
        }
        return str.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.agentName);
        out.writeBoolean(this.changesOnly);
        out.writeInt(this.availabilities.size());
        for (Availability availability : this.availabilities) {
            out.writeInt(availability.getResource().getId());
            if (availability.getAvailabilityType() != null) {
                out.writeInt(availability.getAvailabilityType().ordinal());
            } else {
                out.writeInt(-1);
            }
            out.writeLong(availability.getStartTime().getTime());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.agentName = (String)in.readObject();
        this.changesOnly = in.readBoolean();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int resourceId = in.readInt();
            int avail = in.readInt();
            AvailabilityType at = avail > -1 ? AvailabilityType.values()[avail] : null;
            Date startTime = new Date(in.readLong());
            Resource r = new Resource(resourceId);
            Availability a = new Availability(r, startTime, at);
            this.availabilities.add(a);
        }
    }
}

