/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.Collection;
import org.jboss.dependency.plugins.AbstractControllerContext;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContextActions;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileContext
extends AbstractControllerContext {
    private ProfileMetaData metaData;
    private Profile profile;

    protected static ProfileKey getProfileKey(Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("Null profile.");
        }
        return profile.getKey();
    }

    public ProfileContext(Profile profile, ControllerContextActions actions) {
        super((Object)ProfileContext.getProfileKey(profile), actions);
        this.setMode(ControllerMode.ON_DEMAND);
        this.createDependencies(profile.getKey(), profile.getSubProfiles());
        this.profile = profile;
        this.setTarget(profile);
    }

    public ProfileContext(ProfileKey key, ProfileMetaData metaData, ControllerContextActions actions) {
        super((Object)key, actions);
        if (this.metaData == null) {
            throw new IllegalArgumentException("Null meta data.");
        }
        this.metaData = metaData;
    }

    public Profile getProfile() {
        return this.profile;
    }

    private void createDependencies(ProfileKey key, Collection<ProfileKey> subProfiles) {
        if (subProfiles != null && !subProfiles.isEmpty()) {
            for (ProfileKey iDependOn : subProfiles) {
                this.getDependencyInfo().addIDependOn(this.createDependencyItem(key, iDependOn));
            }
        }
    }

    private DependencyItem createDependencyItem(ProfileKey key, ProfileKey iDependOn) {
        return new AbstractDependencyItem((Object)key, (Object)iDependOn, ControllerState.DESCRIBED, ControllerState.INSTALLED);
    }

    public String toString() {
        return this.profile.toString();
    }
}

