/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs.operations;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.operations.ValueFileOperation;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class WriteValue
extends ValueFileOperation {
    protected final File file;
    protected final ValueData value;
    protected ValueFileOperation.ValueFileLock fileLock;

    public WriteValue(File file, ValueData value, ValueDataResourceHolder resources, FileCleaner cleaner, File tempDir) {
        super(resources, cleaner, tempDir);
        this.file = file;
        this.value = value;
    }

    public void execute() throws IOException {
        this.makePerformed();
        this.fileLock = new ValueFileOperation.ValueFileLock(this.file);
        this.fileLock.lock();
    }

    public void rollback() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (this.fileLock != null) {
            try {
                this.file.getParentFile().mkdirs();
                this.writeValue(this.file, this.value);
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.fileLock.unlock();
                throw throwable;
            }
            this.fileLock.unlock();
            {
            }
        }
    }
}

