/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;

public class SelectLockingStrategy
implements LockingStrategy {
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String sql;

    public SelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        this.sql = this.generateLockString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable id, Object version, Object object, SessionImplementor session) throws StaleObjectStateException, JDBCException {
        SessionFactoryImplementor factory = session.getFactory();
        try {
            PreparedStatement st = session.getBatcher().prepareSelectStatement(this.sql);
            try {
                this.lockable.getIdentifierType().nullSafeSet(st, id, 1, session);
                if (this.lockable.isVersioned()) {
                    this.lockable.getVersionType().nullSafeSet(st, version, this.lockable.getIdentifierType().getColumnSpan(factory) + 1, session);
                }
                ResultSet rs = st.executeQuery();
                try {
                    if (!rs.next()) {
                        if (factory.getStatistics().isStatisticsEnabled()) {
                            factory.getStatisticsImplementor().optimisticFailure(this.lockable.getEntityName());
                        }
                        throw new StaleObjectStateException(this.lockable.getEntityName(), id);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                session.getBatcher().closeStatement(st);
                throw throwable;
            }
            session.getBatcher().closeStatement(st);
            {
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not lock: " + MessageHelper.infoString((EntityPersister)this.lockable, id, session.getFactory()), this.sql);
        }
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }

    protected String generateLockString() {
        SessionFactoryImplementor factory = this.lockable.getFactory();
        SimpleSelect select = new SimpleSelect(factory.getDialect()).setLockMode(this.lockMode).setTableName(this.lockable.getRootTableName()).addColumn(this.lockable.getRootTableIdentifierColumnNames()[0]).addCondition(this.lockable.getRootTableIdentifierColumnNames(), "=?");
        if (this.lockable.isVersioned()) {
            select.addCondition(this.lockable.getVersionColumnName(), "=?");
        }
        if (factory.getSettings().isCommentsEnabled()) {
            select.setComment(this.lockMode + " lock " + this.lockable.getEntityName());
        }
        return select.toStatementString();
    }
}

