/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.AbstractProcessor;
import org.jboss.metadata.annotation.creator.AnnotationContext;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCreator<MD>
extends AbstractFinderUser {
    private List<Processor<MD, Class<?>>> processors = new ArrayList();
    private Map<AbstractProcessor.Scope, Set<Class<? extends Annotation>>> processedAnnotations = new HashMap<AbstractProcessor.Scope, Set<Class<? extends Annotation>>>();

    protected AbstractCreator(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public abstract MD create(Collection<Class<?>> var1);

    protected <T extends MD> void processMetaData(Collection<Class<?>> classes, T metaData) {
        Collection<Class<?>> validatedClasses = this.validateClasses(classes);
        if (validatedClasses.isEmpty()) {
            return;
        }
        for (Class<?> clazz : validatedClasses) {
            this.process(metaData, clazz);
        }
    }

    protected abstract boolean validateClass(Class<?> var1);

    protected Collection<Class<?>> validateClasses(Collection<Class<?>> classes) {
        HashSet validatedClasses = new HashSet();
        for (Class<?> clazz : classes) {
            if (!this.validateClass(clazz)) continue;
            validatedClasses.add(clazz);
        }
        return validatedClasses;
    }

    public void addProcessor(Processor<MD, Class<?>> processor) {
        if (processor == null) {
            throw new IllegalArgumentException("null processor.");
        }
        if (processor instanceof AbstractProcessor) {
            this.addAnnotations((AbstractProcessor)((Object)processor));
        } else {
            this.addAnnotations(AbstractProcessor.Scope.TYPE, processor.getAnnotationTypes());
        }
        this.processors.add(processor);
    }

    protected void process(MD metaData, Class<?> type) {
        if (metaData == null) {
            throw new IllegalArgumentException("null metadata.");
        }
        if (type == null) {
            throw new IllegalArgumentException("null classes;");
        }
        for (Processor<MD, Class<?>> processor : this.processors) {
            processor.process(metaData, type);
        }
    }

    private void addAnnotations(AbstractProcessor processor) {
        this.addAnnotations(AbstractProcessor.Scope.TYPE, processor.getProcessedAnnotations(AbstractProcessor.Scope.TYPE));
        this.addAnnotations(AbstractProcessor.Scope.METHOD, processor.getProcessedAnnotations(AbstractProcessor.Scope.METHOD));
        this.addAnnotations(AbstractProcessor.Scope.FIELD, processor.getProcessedAnnotations(AbstractProcessor.Scope.FIELD));
    }

    private void addAnnotations(AbstractProcessor.Scope scope, Collection<Class<? extends Annotation>> annotations) {
        if (annotations == null) {
            return;
        }
        if (scope == null) {
            throw new IllegalArgumentException("null scope.");
        }
        if (this.processedAnnotations.get((Object)scope) == null) {
            this.processedAnnotations.put(scope, new HashSet());
        }
        this.processedAnnotations.get((Object)scope).addAll(annotations);
    }

    protected Collection<Class<? extends Annotation>> getAnnotationsForScope(AbstractProcessor.Scope scope) {
        return this.processedAnnotations.get((Object)scope);
    }

    public AnnotationContext getAnnotationContext() {
        return new AnnotationContext(){

            @Override
            public Collection<Class<? extends Annotation>> getFieldAnnotations() {
                return (Collection)AbstractCreator.this.processedAnnotations.get((Object)AbstractProcessor.Scope.FIELD);
            }

            @Override
            public Collection<Class<? extends Annotation>> getMethodAnnotations() {
                return (Collection)AbstractCreator.this.processedAnnotations.get((Object)AbstractProcessor.Scope.METHOD);
            }

            @Override
            public Collection<Class<? extends Annotation>> getTypeAnnotations() {
                return (Collection)AbstractCreator.this.processedAnnotations.get((Object)AbstractProcessor.Scope.TYPE);
            }
        };
    }
}

