/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterFileTransferException;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerConfigLocator;

public class ClusterFileTransfer
implements HAPartition.AsynchHAMembershipListener {
    private static final int MAX_CHUNK_BUFFER_SIZE = 524288;
    private Map mPushsInProcess = Collections.synchronizedMap(new HashMap());
    private Map mPullsInProcess = Collections.synchronizedMap(new HashMap());
    private HAPartition mPartition;
    private static final File TEMP_DIRECTORY = ServerConfigLocator.locate().getServerTempDir();
    private Map mParentFolders = null;
    private static final String SERVICE_NAME = ClusterFileTransfer.class.getName() + "Service";
    private static final Logger log = Logger.getLogger((String)ClusterFileTransfer.class.getName());

    public ClusterFileTransfer(HAPartition partition, Map destinationDirectoryMap) {
        this.mPartition = partition;
        this.mPartition.registerRPCHandler(SERVICE_NAME, (Object)this);
        this.mPartition.registerMembershipListener((HAPartition.HAMembershipListener)this);
        this.mParentFolders = destinationDirectoryMap;
    }

    public void pull(File file, String parentName) throws ClusterFileTransferException {
        String myNodeName = this.mPartition.getNodeName();
        ClusterNode myNodeAddress = this.mPartition.getClusterNode();
        FileOutputStream output = null;
        try {
            log.info((Object)("Start pull of file " + file.getName() + " from cluster."));
            ArrayList response = this.mPartition.callMethodOnCoordinatorNode(SERVICE_NAME, "remotePullOpenFile", new Object[]{file, myNodeName, myNodeAddress, parentName}, new Class[]{File.class, String.class, ClusterNode.class, String.class}, true);
            if (response == null || response.size() < 1) {
                throw new ClusterFileTransferException("Did not receive response from remote machine trying to open file '" + file + "'.  Check remote machine error log.");
            }
            FileContentChunk fileChunk = (FileContentChunk)response.get(0);
            if (null == fileChunk) {
                throw new ClusterFileTransferException("An error occured on remote machine trying to open file '" + file + "'.  Check remote machine error log.");
            }
            File tempFile = new File(ClusterFileTransfer.getServerTempDir(), file.getName());
            output = new FileOutputStream(tempFile);
            long lastModification = fileChunk.lastModified();
            while (fileChunk.mByteCount > 0) {
                output.write(fileChunk.mChunk, 0, fileChunk.mByteCount);
                response = this.mPartition.callMethodOnCoordinatorNode(SERVICE_NAME, "remotePullReadFile", new Object[]{file, myNodeName}, new Class[]{File.class, String.class}, true);
                if (response.size() < 1) {
                    if (!tempFile.delete()) {
                        throw new ClusterFileTransferException("An error occured on remote machine trying to read file '" + file + "'.  Is remote still running?  Also, we couldn't delete temp file " + tempFile.getName());
                    }
                    throw new ClusterFileTransferException("An error occured on remote machine trying to read file '" + file + "'.  Is remote still running?");
                }
                fileChunk = (FileContentChunk)response.get(0);
                if (null != fileChunk) continue;
                if (!tempFile.delete()) {
                    throw new ClusterFileTransferException("An error occured on remote machine trying to read file '" + file + "'.  Check remote machine error log.  Also, we couldn't delete temp file " + tempFile.getName());
                }
                throw new ClusterFileTransferException("An error occured on remote machine trying to read file '" + file + "'.  Check remote machine error log.");
            }
            output.close();
            output = null;
            File target = new File(this.getParentFile(parentName), file.getName());
            if (target.exists() && !target.delete()) {
                throw new ClusterFileTransferException("The destination file " + target + " couldn't be deleted, the updated application will not be copied to this node");
            }
            tempFile.setLastModified(lastModification);
            if (!ClusterFileTransfer.localMove(tempFile, target)) {
                throw new ClusterFileTransferException("Could not move " + tempFile + " to " + target);
            }
            log.info((Object)("Finished cluster pull of file " + file.getName() + " to " + target.getName()));
        }
        catch (IOException e) {
            throw new ClusterFileTransferException(e);
        }
        catch (ClusterFileTransferException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClusterFileTransferException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    ClusterFileTransfer.logException(e);
                }
            }
        }
    }

    public FileContentChunk remotePullOpenFile(File file, String originNodeName, ClusterNode originNode, String parentName) {
        try {
            File target = new File(this.getParentFile(parentName), file.getName());
            FileContentChunk fileChunk = new FileContentChunk(target, originNodeName, originNode);
            FilePullOperation filePullOperation = new FilePullOperation(fileChunk);
            this.mPullsInProcess.put(this.CompositeKey(originNodeName, file.getName()), filePullOperation);
            filePullOperation.openInputFile();
            fileChunk.readNext(filePullOperation.getInputStream());
            return fileChunk;
        }
        catch (IOException e) {
            ClusterFileTransfer.logException(e);
        }
        catch (Exception e) {
            ClusterFileTransfer.logException(e);
        }
        return null;
    }

    public FileContentChunk remotePullReadFile(File file, String originNodeName) {
        try {
            FilePullOperation filePullOperation = (FilePullOperation)this.mPullsInProcess.get(this.CompositeKey(originNodeName, file.getName()));
            filePullOperation.getFileChunk().readNext(filePullOperation.getInputStream());
            if (filePullOperation.getFileChunk().mByteCount < 1) {
                filePullOperation.getInputStream().close();
                this.mPullsInProcess.remove(this.CompositeKey(originNodeName, file.getName()));
            }
            return filePullOperation.getFileChunk();
        }
        catch (IOException e) {
            ClusterFileTransfer.logException(e);
            return null;
        }
    }

    public void push(File file, String parentName, boolean leaveInTempFolder) throws ClusterFileTransferException {
        File target = new File(this.getParentFile(parentName), file.getName());
        log.info((Object)("Start push of file " + file.getName() + " to cluster."));
        if (target.isDirectory()) {
            ClusterFileTransfer.logMessage("You cannot send the contents of directories, consider archiving folder containing" + target.getName() + " instead.");
            return;
        }
        ClusterNode myNodeAddress = this.mPartition.getClusterNode();
        FileContentChunk fileChunk = new FileContentChunk(target, this.mPartition.getNodeName(), myNodeAddress);
        try {
            InputStream input = fileChunk.openInputFile();
            while (fileChunk.readNext(input) >= 0) {
                this.mPartition.callMethodOnCluster(SERVICE_NAME, "remotePushWriteFile", new Object[]{fileChunk, parentName}, new Class[]{fileChunk.getClass(), String.class}, true);
            }
            this.mPartition.callMethodOnCluster(SERVICE_NAME, "remotePushCloseFile", new Object[]{fileChunk, new Boolean(leaveInTempFolder), parentName}, new Class[]{fileChunk.getClass(), Boolean.class, String.class}, true);
            input.close();
            log.info((Object)("Finished push of file " + file.getName() + " to cluster."));
        }
        catch (FileNotFoundException e) {
            throw new ClusterFileTransferException(e);
        }
        catch (IOException e) {
            throw new ClusterFileTransferException(e);
        }
        catch (Exception e) {
            throw new ClusterFileTransferException(e);
        }
    }

    public void remotePushWriteFile(FileContentChunk fileChunk, String parentName) {
        try {
            String key = this.CompositeKey(fileChunk.getOriginatingNodeName(), fileChunk.getDestinationFile().getName());
            FilePushOperation filePushOperation = (FilePushOperation)this.mPushsInProcess.get(key);
            if (filePushOperation == null) {
                if (fileChunk.mChunkNumber != 1) {
                    ClusterFileTransfer.logMessage("Ignoring file transfer of '" + fileChunk.getDestinationFile().getName() + "' from " + fileChunk.getOriginatingNodeName() + ", we missed the start of it.");
                    return;
                }
                filePushOperation = new FilePushOperation(fileChunk.getOriginatingNodeName(), fileChunk.getOriginatingNode());
                File tempFile = new File(ClusterFileTransfer.getServerTempDir(), fileChunk.getDestinationFile().getName());
                filePushOperation.openOutputFile(tempFile);
                this.mPushsInProcess.put(key, filePushOperation);
            }
            filePushOperation.getOutputStream().write(fileChunk.mChunk, 0, fileChunk.mByteCount);
        }
        catch (FileNotFoundException e) {
            ClusterFileTransfer.logException(e);
        }
        catch (IOException e) {
            ClusterFileTransfer.logException(e);
        }
    }

    public void remotePushCloseFile(FileContentChunk fileChunk, Boolean leaveInTempFolder, String parentName) {
        try {
            FilePushOperation filePushOperation = (FilePushOperation)this.mPushsInProcess.remove(this.CompositeKey(fileChunk.getOriginatingNodeName(), fileChunk.getDestinationFile().getName()));
            if (filePushOperation != null && filePushOperation.getOutputStream() != null) {
                filePushOperation.getOutputStream().close();
                if (!leaveInTempFolder.booleanValue()) {
                    File tempFile = new File(ClusterFileTransfer.getServerTempDir(), fileChunk.getDestinationFile().getName());
                    File target = new File(this.getParentFile(parentName), fileChunk.getDestinationFile().getName());
                    if (target.exists() && !target.delete()) {
                        ClusterFileTransfer.logMessage("Could not delete target file " + target);
                    }
                    tempFile.setLastModified(fileChunk.lastModified());
                    if (!ClusterFileTransfer.localMove(tempFile, target)) {
                        ClusterFileTransfer.logMessage("Could not move " + tempFile + " to " + target);
                    }
                }
            }
        }
        catch (IOException e) {
            ClusterFileTransfer.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
        Iterator iter;
        Collection values;
        Map map;
        if (this.mPushsInProcess.size() > 0) {
            map = this.mPushsInProcess;
            synchronized (map) {
                values = this.mPushsInProcess.values();
                iter = values.iterator();
                while (iter.hasNext()) {
                    FilePushOperation push = (FilePushOperation)iter.next();
                    if (!deadMembers.contains(push.getOriginatingNode())) continue;
                    push.cancel();
                    iter.remove();
                }
            }
        }
        if (this.mPullsInProcess.size() > 0) {
            map = this.mPullsInProcess;
            synchronized (map) {
                values = this.mPullsInProcess.values();
                iter = values.iterator();
                while (iter.hasNext()) {
                    FilePullOperation pull = (FilePullOperation)iter.next();
                    if (!deadMembers.contains(pull.getFileChunk().getOriginatingNode())) continue;
                    pull.cancel();
                    iter.remove();
                }
            }
        }
    }

    private static File getServerTempDir() {
        return TEMP_DIRECTORY;
    }

    private File getParentFile(String parentName) {
        return (File)this.mParentFolders.get(parentName);
    }

    private String CompositeKey(String originNodeName, String fileName) {
        return originNodeName + "#" + fileName;
    }

    private static void logMessage(String message) {
        log.info((Object)message);
    }

    private static void logException(Throwable e) {
        log.error((Object)e);
    }

    public static boolean localMove(File source, File destination) throws FileNotFoundException, IOException {
        if (source.renameTo(destination)) {
            return true;
        }
        FileOutputStream out = new FileOutputStream(destination);
        FileInputStream in = new FileInputStream(source);
        byte[] buffer = new byte[32768];
        int bytesRead = 0;
        while (bytesRead > -1) {
            bytesRead = ((InputStream)in).read(buffer);
            if (bytesRead <= 0) continue;
            ((OutputStream)out).write(buffer, 0, bytesRead);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
        if (!source.delete()) {
            ClusterFileTransfer.logMessage("Could not delete file " + source);
        }
        return true;
    }

    private static class FileContentChunk
    implements Serializable {
        static final long serialVersionUID = 3546447481674749363L;
        private File mDestinationFile;
        private long mLastModified;
        private String mOriginNodeName;
        private ClusterNode mOriginNode;
        private int mChunkNumber;
        private static final int FIRST_CHUNK = 1;
        private byte[] mChunk;
        private int mByteCount;

        public FileContentChunk(File file, String originNodeName, ClusterNode originNode) {
            this.mDestinationFile = file;
            this.mLastModified = file.lastModified();
            this.mOriginNode = originNode;
            this.mOriginNodeName = originNodeName;
            this.mChunkNumber = 0;
            long size = file.length();
            if (size > 524288L) {
                size = 524288L;
            } else if (size <= 0L) {
                size = 1L;
            }
            this.mChunk = new byte[(int)size];
            this.mByteCount = 0;
        }

        public String getOriginatingNodeName() {
            return this.mOriginNodeName;
        }

        public ClusterNode getOriginatingNode() {
            return this.mOriginNode;
        }

        public File getDestinationFile() {
            return this.mDestinationFile;
        }

        public InputStream openInputFile() throws FileNotFoundException {
            return new FileInputStream(this.mDestinationFile);
        }

        public OutputStream openOutputFile() throws FileNotFoundException {
            File lFile = new File(ClusterFileTransfer.getServerTempDir(), this.mDestinationFile.getName());
            FileOutputStream output = new FileOutputStream(lFile);
            return output;
        }

        public int readNext(InputStream input) throws IOException {
            ++this.mChunkNumber;
            this.mByteCount = input.read(this.mChunk);
            return this.mByteCount;
        }

        public long lastModified() {
            return this.mLastModified;
        }
    }

    private static class FilePullOperation {
        private FileContentChunk mFileChunk;
        private InputStream mInput;

        public FilePullOperation(FileContentChunk fileChunk) {
            this.mFileChunk = fileChunk;
        }

        public void openInputFile() throws FileNotFoundException {
            this.mInput = this.mFileChunk.openInputFile();
        }

        public InputStream getInputStream() {
            return this.mInput;
        }

        public void cancel() {
            ClusterFileTransfer.logMessage("Canceling send of file " + this.mFileChunk.getDestinationFile() + " as remote server " + this.mFileChunk.getOriginatingNodeName() + " left the cluster.");
            try {
                this.mInput.close();
            }
            catch (IOException e) {
                ClusterFileTransfer.logException(e);
            }
        }

        public FileContentChunk getFileChunk() {
            return this.mFileChunk;
        }
    }

    private static class FilePushOperation {
        private OutputStream mOutput;
        private String mOriginNodeName;
        private ClusterNode mOriginNode;
        private File mOutputFile;

        public FilePushOperation(String originNodeName, ClusterNode originNode) {
            this.mOriginNodeName = originNodeName;
            this.mOriginNode = originNode;
        }

        public void openOutputFile(File file) throws FileNotFoundException {
            this.mOutput = new FileOutputStream(file);
            this.mOutputFile = file;
        }

        public void cancel() {
            ClusterFileTransfer.logMessage("Canceling receive of file " + this.mOutputFile + " as remote server " + this.mOriginNodeName + " left the cluster.  Partial results will be deleted.");
            try {
                this.mOutput.close();
                if (!this.mOutputFile.delete()) {
                    ClusterFileTransfer.logMessage("Could not delete output file " + this.mOutputFile);
                }
            }
            catch (IOException e) {
                ClusterFileTransfer.logException(e);
            }
        }

        public ClusterNode getOriginatingNode() {
            return this.mOriginNode;
        }

        public OutputStream getOutputStream() {
            return this.mOutput;
        }
    }
}

