/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.client;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class JndiDependencyItem
extends AbstractDependencyItem
implements DependencyItem {
    private static final Logger log = Logger.getLogger(JndiDependencyItem.class);
    private String jndiName;
    private Properties env;
    private String classLoaderName;

    JndiDependencyItem(String jndiName, Properties env, String classLoaderName) {
        this.jndiName = jndiName;
        this.env = env;
        this.classLoaderName = classLoaderName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolve(Controller controller) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            Properties jndiEnv;
            ControllerContext cc = controller.getContext((Object)this.classLoaderName, ControllerState.INSTALLED);
            ClassLoader loader = (ClassLoader)cc.getTarget();
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(loader);
            }
            if ((jndiEnv = this.env) == null) {
                jndiEnv = System.getProperties();
            }
            InitialContext ctx = new InitialContext(jndiEnv);
            Object depends = ctx.lookup(this.jndiName);
            super.setIDependOn(depends);
            log.info((Object)("Resolved(" + this.jndiName + ")" + depends));
            this.setResolved(true);
            boolean bl = this.isResolved();
            return bl;
        }
        catch (NameNotFoundException e) {
            log.debug((Object)"Jndi lookup failed", (Throwable)e);
        }
        catch (Throwable ignored) {
            log.debug((Object)"Unexpected error", ignored);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        this.setResolved(false);
        return this.isResolved();
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" depend=").append(this.jndiName);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName()).append(" depend ").append(this.jndiName);
    }

    public String toHumanReadableString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JndiDepends: '");
        builder.append(this.jndiName);
        builder.append("'");
        return builder.toString();
    }
}

