/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMTerminateSequenceResponse;

final class RMTerminateSequenceResponseSerializer
implements RMSerializer {
    private static final RMSerializer INSTANCE = new RMTerminateSequenceResponseSerializer();

    private RMTerminateSequenceResponseSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMTerminateSequenceResponse o = (RMTerminateSequenceResponse)object;
        try {
            SOAPBody soapBody = soapMessage.getSOAPPart().getEnvelope().getBody();
            RMConstants wsrmConstants = provider.getConstants();
            QName terminateSequenceResponseQName = wsrmConstants.getTerminateSequenceResponseQName();
            SOAPElement terminateSequenceResponseElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapBody, terminateSequenceResponseQName, "soap body");
            QName identifierQName = wsrmConstants.getIdentifierQName();
            SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(terminateSequenceResponseElement, identifierQName, terminateSequenceResponseQName);
            String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
            o.setIdentifier(identifier);
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMTerminateSequenceResponse o = (RMTerminateSequenceResponse)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName terminateSequenceResponseQName = wsrmConstants.getTerminateSequenceResponseQName();
            SOAPElement terminateSequenceResponseElement = soapEnvelope.getBody().addChildElement(terminateSequenceResponseQName);
            QName identifierQName = wsrmConstants.getIdentifierQName();
            terminateSequenceResponseElement.addChildElement(identifierQName).setValue(o.getIdentifier());
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

