/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.EventTypeSet;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.LogUtil;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyComm.NotifySubscribe;

public class CallbackManager
extends EventTypeSet
implements Disposable {
    private final AtomicInteger callbackIdPool_ = new AtomicInteger(0);
    private final Map callbacks_ = new HashMap();
    private final Logger logger_ = LogUtil.getLogger(this.getClass().getName());

    public int attach_callback(NotifySubscribe notifySubscribe) {
        int n = this.callbackIdPool_.getAndIncrement();
        Integer n2 = new Integer(n);
        this.callbacks_.put(n2, notifySubscribe);
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("attach_callback: ID=" + n + " Subscriber=" + notifySubscribe);
        }
        return n;
    }

    public void detach_callback(int n) {
        Object v = this.callbacks_.remove(new Integer(n));
        if (this.logger_.isInfoEnabled()) {
            boolean bl = v != null;
            this.logger_.info("detach_callback: ID=" + n + " Success=" + bl);
        }
    }

    public int[] get_callbacks() {
        Integer[] integerArray = this.callbacks_.keySet().toArray(new Integer[0]);
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    protected void actionSetChanged(EventType[] eventTypeArray, EventType[] eventTypeArray2) {
        Iterator iterator = this.callbacks_.keySet().iterator();
        while (iterator.hasNext()) {
            NotifySubscribe notifySubscribe = (NotifySubscribe)this.callbacks_.get(iterator.next());
            try {
                notifySubscribe.subscription_change(eventTypeArray, eventTypeArray2);
            }
            catch (InvalidEventType invalidEventType) {
                this.logger_.warn("error during subscription_change", (Throwable)invalidEventType);
            }
        }
    }

    public void replaceWith(EventType[] eventTypeArray) {
        this.changeSet(eventTypeArray, this.getAllTypes());
    }

    public void dispose() {
        this.callbacks_.clear();
    }
}

