/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.plugins.annotations.CommitElement;
import org.jboss.deployers.plugins.annotations.DefaultAnnotationEnvironment;
import org.jboss.deployers.plugins.annotations.EnvPutList;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.metadata.spi.signature.javassist.JavassistConstructorParametersSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistMethodParametersSignature;
import org.jboss.metadata.spi.signature.javassist.JavassistSignatureFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericAnnotationResourceVisitor
implements ResourceVisitor {
    private static final Logger log = Logger.getLogger(GenericAnnotationResourceVisitor.class);
    private ResourceFilter resourceFilter = ClassFilter.INSTANCE;
    private ClassPool pool;
    private boolean forceAnnotations;
    private boolean checkSuper;
    private boolean checkInterfaces = true;
    private DefaultAnnotationEnvironment env;
    private CtClass objectCtClass;

    public GenericAnnotationResourceVisitor(ClassLoader classLoader) {
        this(ClassPool.getDefault(), classLoader);
    }

    public GenericAnnotationResourceVisitor(ClassPool pool, ClassLoader classLoader) {
        if (pool == null) {
            throw new IllegalArgumentException("Null pool");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        this.pool = pool;
        this.env = new DefaultAnnotationEnvironment(classLoader);
        this.objectCtClass = pool.makeClass(Object.class.getName());
    }

    public ResourceFilter getFilter() {
        return this.resourceFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(ResourceContext resource) {
        try {
            InputStream stream = resource.getInputStream();
            if (stream == null) {
                throw new IllegalArgumentException("Null resource input stream: " + resource);
            }
            try {
                CtClass ctClass = this.pool.makeClass(stream);
                try {
                    List<CommitElement> commit = this.createCommitList();
                    this.handleCtClass(ctClass, commit);
                    if (!commit.isEmpty()) {
                        for (CommitElement ce : commit) {
                            this.env.putAnnotation(ce.getAnnotation(), ce.getType(), ce.getClassName(), ce.getSignature());
                        }
                    }
                }
                finally {
                    ctClass.detach();
                }
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (ClassNotFoundException e) {
            if (this.forceAnnotations) {
                throw new RuntimeException(e);
            }
            this.logThrowable(resource, e);
        }
        catch (Throwable t) {
            this.logThrowable(resource, t);
        }
    }

    protected List<CommitElement> createCommitList() {
        return this.forceAnnotations ? new EnvPutList(this.env) : new ArrayList();
    }

    protected void logThrowable(ResourceContext resource, Throwable t) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Exception reading resource: " + resource.getResourceName()), t);
        }
    }

    protected void handleCtClass(CtClass ctClass, List<CommitElement> commit) throws ClassNotFoundException, NotFoundException {
        if (ctClass == null || this.objectCtClass.equals(ctClass)) {
            return;
        }
        String className = ctClass.getName();
        if (this.env.isAlreadyChecked(className)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Skipping already checked class name: " + className));
            }
            return;
        }
        if (!this.checkInterfaces && ctClass.isInterface()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Skipping interface: " + className));
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scanning class " + className + " for annotations"));
        }
        Object[] annotations = this.forceAnnotations ? ctClass.getAnnotations() : ctClass.getAvailableAnnotations();
        GenericAnnotationResourceVisitor.handleAnnotations(ElementType.TYPE, (Signature)null, annotations, className, commit);
        this.handleCtMembers(ElementType.CONSTRUCTOR, (CtMember[])ctClass.getDeclaredConstructors(), className, commit);
        this.handleCtMembers(ElementType.METHOD, (CtMember[])ctClass.getDeclaredMethods(), className, commit);
        this.handleCtMembers(ElementType.FIELD, (CtMember[])ctClass.getDeclaredFields(), className, commit);
        if (this.checkSuper) {
            CtClass[] interfaces;
            if (this.checkInterfaces && (interfaces = ctClass.getInterfaces()) != null && interfaces.length > 0) {
                for (CtClass intf : interfaces) {
                    this.handleCtClass(intf, commit);
                }
            }
            this.handleCtClass(ctClass.getSuperclass(), commit);
        }
    }

    protected void handleCtMembers(ElementType type, CtMember[] members, String className, List<CommitElement> commit) throws ClassNotFoundException {
        if (members != null && members.length > 0) {
            for (CtMember member : members) {
                Object[] annotations = this.forceAnnotations ? member.getAnnotations() : member.getAvailableAnnotations();
                GenericAnnotationResourceVisitor.handleAnnotations(type, member, annotations, className, commit);
                if (!(member instanceof CtBehavior)) continue;
                CtBehavior behavior = (CtBehavior)member;
                Object[][] paramAnnotations = this.forceAnnotations ? behavior.getParameterAnnotations() : behavior.getAvailableParameterAnnotations();
                for (int index = 0; index < paramAnnotations.length; ++index) {
                    GenericAnnotationResourceVisitor.handleAnnotations(ElementType.PARAMETER, GenericAnnotationResourceVisitor.getBehaviorSignature(behavior, index), paramAnnotations[index], className, commit);
                }
            }
        }
    }

    protected static Signature getBehaviorSignature(CtBehavior behavior, int index) throws ClassNotFoundException {
        try {
            if (behavior instanceof CtConstructor) {
                return new JavassistConstructorParametersSignature((CtConstructor)behavior, index);
            }
            if (behavior instanceof CtMethod) {
                return new JavassistMethodParametersSignature((CtMethod)behavior, index);
            }
            throw new IllegalArgumentException("Unknown ct behavior: " + behavior);
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException("Exception creating signature: " + behavior, e);
        }
    }

    protected static void handleAnnotations(ElementType type, CtMember member, Object[] annotations, String className, List<CommitElement> commit) {
        Signature signature = null;
        if (member != null) {
            signature = JavassistSignatureFactory.getSignature((CtMember)member);
        }
        GenericAnnotationResourceVisitor.handleAnnotations(type, signature, annotations, className, commit);
    }

    protected static void handleAnnotations(ElementType type, Signature signature, Object[] annotations, String className, List<CommitElement> commit) {
        if (annotations != null && annotations.length > 0) {
            for (Object annObject : annotations) {
                Annotation annotation = (Annotation)Annotation.class.cast(annObject);
                commit.add(new CommitElement(annotation, type, className, signature));
            }
        }
    }

    public void setResourceFilter(ResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    public void setForceAnnotations(boolean forceAnnotations) {
        this.forceAnnotations = forceAnnotations;
    }

    public void setKeepAnnotations(boolean keepAnnotations) {
        this.env.setKeepAnnotations(keepAnnotations);
    }

    public void setCheckSuper(boolean checkSuper) {
        this.checkSuper = checkSuper;
    }

    public void setCheckInterfaces(boolean checkInterfaces) {
        this.checkInterfaces = checkInterfaces;
    }

    public AnnotationEnvironment getEnv() {
        return this.env;
    }
}

