/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.exoplatform.commons.utils.Tools;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProfileDOMFilter {
    private static final String PROFILE_ATTRIBUTE = "profiles";
    private static final Set<String> kernelURIs = Tools.set((Object[])new String[]{"http://www.exoplaform.org/xml/ns/kernel_1_0.xsd", "http://www.exoplaform.org/xml/ns/kernel_1_1.xsd"});
    private static final Set<String> kernelWithProfileURIs = Tools.set((Object[])new String[]{"http://www.exoplaform.org/xml/ns/kernel_1_1.xsd"});
    private final Set<String> activeProfiles;

    public ProfileDOMFilter(Set<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void process(Element elt) {
        NamedNodeMap attrs;
        if (kernelURIs.contains(elt.getNamespaceURI()) && (attrs = elt.getAttributes()) != null) {
            Set profiles = null;
            ArrayList<Attr> toRemove = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                String attrURI = attr.getNamespaceURI();
                if (attrURI != null && !kernelWithProfileURIs.contains(attrURI) || !PROFILE_ATTRIBUTE.equals(attr.getLocalName())) continue;
                if (profiles == null) {
                    profiles = Tools.parseCommaList((String)attr.getValue());
                } else {
                    profiles.addAll(Tools.parseCommaList((String)attr.getValue()));
                }
                if (toRemove == null) {
                    toRemove = new ArrayList<Attr>();
                }
                toRemove.add(attr);
            }
            if (profiles != null && Collections.disjoint(this.activeProfiles, profiles)) {
                Node parent = elt.getParentNode();
                parent.removeChild(elt);
                return;
            }
            if (toRemove != null) {
                for (Attr attr : toRemove) {
                    elt.removeAttributeNode(attr);
                }
            }
        }
        NodeList children = elt.getChildNodes();
        ArrayList<Element> childElts = new ArrayList<Element>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            childElts.add((Element)child);
        }
        for (Element childElt : childElts) {
            this.process(childElt);
        }
    }
}

