/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.management.ValueWrapper;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.data.RestResourceMethod;
import org.exoplatform.management.data.RestResourceProperty;
import org.exoplatform.management.invocation.MethodInvoker;
import org.exoplatform.management.spi.ManagedMethodMetaData;
import org.exoplatform.management.spi.ManagedPropertyMetaData;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagedTypeMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestResource {
    final Map<String, RestResourceProperty> properties;
    private final List<RestResourceMethod> methods;
    private final ManagedResource managedResource;
    private final String name;
    private final String description;

    public RestResource(String name, ManagedResource managedResource) {
        ManagedTypeMetaData managedType = managedResource.getMetaData();
        HashMap<String, RestResourceProperty> properties = new HashMap<String, RestResourceProperty>();
        for (ManagedPropertyMetaData managedProperty : managedType.getProperties()) {
            RestResourceProperty resourceProperty = new RestResourceProperty(managedProperty);
            properties.put(resourceProperty.getName(), resourceProperty);
        }
        ArrayList<RestResourceMethod> methods = new ArrayList<RestResourceMethod>();
        for (ManagedMethodMetaData managedMethod : managedType.getMethods()) {
            RestResourceMethod resourceMethod = new RestResourceMethod(managedMethod);
            methods.add(resourceMethod);
        }
        this.name = name;
        this.description = managedType.getDescription();
        this.managedResource = managedResource;
        this.properties = Collections.unmodifiableMap(properties);
        this.methods = methods;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<RestResourceProperty> getProperties() {
        return this.properties.values();
    }

    public Collection<RestResourceMethod> getMethods() {
        return this.methods;
    }

    @GET
    @Produces(value={"application/json"})
    public RestResource get() {
        return this;
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Object get(@Context UriInfo info, @PathParam(value="name") String name) {
        MethodInvoker getter;
        RestResourceProperty property = this.properties.get(name);
        if (property != null && (getter = property.getGetterInvoker()) != null) {
            return this.safeInvoke(getter, (Map<String, List<String>>)info.getQueryParameters());
        }
        return this.tryInvoke(name, info, ImpactType.READ);
    }

    @PUT
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Object put(@Context UriInfo info, @PathParam(value="name") String name) {
        MethodInvoker setter;
        RestResourceProperty property = this.properties.get(name);
        if (property != null && (setter = property.getSetterInvoker()) != null) {
            return this.safeInvoke(setter, (Map<String, List<String>>)info.getQueryParameters());
        }
        return this.tryInvoke(name, info, ImpactType.IDEMPOTENT_WRITE);
    }

    @POST
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Object post(@Context UriInfo info, @PathParam(value="name") String name) {
        return this.tryInvoke(name, info, ImpactType.WRITE);
    }

    private Object tryInvoke(String methodName, UriInfo info, ImpactType impact) {
        MultivaluedMap parameters = info.getQueryParameters();
        RestResourceMethod method = this.lookupMethod(methodName, parameters.keySet(), impact);
        if (method != null) {
            MethodInvoker invoker = method.getMethodInvoker();
            return this.safeInvoke(invoker, (Map<String, List<String>>)parameters);
        }
        return null;
    }

    private RestResourceMethod lookupMethod(String methodName, Set<String> argNames, ImpactType impact) {
        for (RestResourceMethod method : this.methods) {
            if (!method.getName().equals(methodName) || method.metaData.getImpact() != impact || !((Object)method.parameterNames).equals(argNames)) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object safeInvoke(MethodInvoker invoker, Map<String, List<String>> argMap) {
        Object resource = this.managedResource.getResource();
        this.managedResource.beforeInvoke(resource);
        try {
            Object ret = invoker.invoke(resource, argMap);
            Object object = ret == null ? Response.ok() : ValueWrapper.wrap(ret);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Response.ResponseBuilder responseBuilder = Response.serverError();
            return responseBuilder;
        }
        finally {
            this.managedResource.afterInvoke(resource);
        }
    }
}

