/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.BusinessKey;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.SharedRelationships;
import org.apache.juddi.datatype.response.RelatedBusinessInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class RelatedBusinessInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "relatedBusinessInfo";
    private HandlerMaker maker = null;

    protected RelatedBusinessInfoHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        int i;
        RelatedBusinessInfo obj = new RelatedBusinessInfo();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "businessKey");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("businessKey");
            obj.setBusinessKey((BusinessKey)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "name");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("name");
            Name name = (Name)handler.unmarshal((Element)nodeList.elementAt(i));
            if (name == null) continue;
            obj.addName(name);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            Description descr = (Description)handler.unmarshal((Element)nodeList.elementAt(i));
            if (descr == null) continue;
            obj.addDescription(descr);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "sharedRelationships");
        if (nodeList.size() > 0) {
            handler = this.maker.lookup("sharedRelationships");
            obj.setSharedRelationships((SharedRelationships)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        SharedRelationships relationships;
        Vector descVector;
        Vector nameVector;
        RelatedBusinessInfo info = (RelatedBusinessInfo)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String businessKey = info.getBusinessKey();
        if (businessKey != null) {
            handler = this.maker.lookup("businessKey");
            handler.marshal(new BusinessKey(businessKey), element);
        }
        if ((nameVector = info.getNameVector()) != null && nameVector.size() > 0) {
            handler = this.maker.lookup("name");
            for (int i = 0; i < nameVector.size(); ++i) {
                handler.marshal((Name)nameVector.elementAt(i), element);
            }
        }
        if ((descVector = info.getDescriptionVector()) != null && descVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descVector.size(); ++i) {
                handler.marshal((Description)descVector.elementAt(i), element);
            }
        }
        if ((relationships = info.getSharedRelationships()) != null) {
            handler = this.maker.lookup("sharedRelationships");
            handler.marshal(relationships, element);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        RelatedBusinessInfo info = new RelatedBusinessInfo();
        info.setBusinessKey("");
        info.setBusinessKey("6c0ac186-d36b-4b81-bd27-066a5fe0fc1f");
        info.addName(new Name("businessNm"));
        info.addName(new Name("businessNm2", "en"));
        info.addDescription(new Description("business whatever"));
        info.addDescription(new Description("business whatever too", "fr"));
        info.addKeyedReference(new KeyedReference("idBagKeyName", "idBagkeyValue"));
        info.addKeyedReference(new KeyedReference("uuid:f78a135a-4769-4e79-8604-54d440314bc0", "idBagKeyName2", "idBagkeyValue2"));
        System.out.println();
        RegistryObject regObject = info;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

