/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.FileLock;
import com.arjuna.ats.internal.arjuna.objectstore.FileSystemStore;
import java.io.File;

public abstract class FileLockingStore
extends FileSystemStore {
    protected abstract InputObjectState read_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    protected abstract boolean remove_state(Uid var1, String var2, int var3) throws ObjectStoreException;

    protected abstract boolean write_state(Uid var1, String var2, OutputObjectState var3, int var4) throws ObjectStoreException;

    public FileLockingStore(String locationOfStore, int ss) {
        super(locationOfStore, ss);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 4L, 16L, "FileLockingStore.FileLockingStore(" + locationOfStore + ")");
        }
    }

    protected FileLockingStore(ObjectName objName) {
        super(objName);
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(1L, 2L, 16L, "FileLockingStore.FileLockingStore(" + objName + ")");
        }
    }

    protected synchronized boolean lock(File fd, int lmode, boolean create) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "FileLockingStore.lock(" + fd + ", " + FileLock.modeString(lmode) + ", " + create + ")");
        }
        FileLock fileLock = new FileLock(fd);
        return fileLock.lock(lmode, create);
    }

    protected synchronized boolean unlock(File fd) {
        if (tsLogger.arjLogger.debugAllowed()) {
            tsLogger.arjLogger.debug(16L, 2L, 16L, "FileLockingStore.unlock(" + fd + ")");
        }
        FileLock fileLock = new FileLock(fd);
        return fileLock.unlock();
    }
}

