/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.RoleType;

public class MembershipTypeDAOImpl
implements MembershipTypeHandler {
    public static final String MEMBERSHIP_DESCRIPTION = "description";
    public static final String MEMBERSHIP_OWNER = "owner";
    public static final String MEMBERSHIP_CREATE_DATE = "create_date";
    public static final String MEMBERSHIP_MODIFIED_DATE = "modified_date";
    public static final DateFormat dateFormat = DateFormat.getInstance();
    private PicketLinkIDMService service_;
    private PicketLinkIDMOrganizationServiceImpl orgService;

    public MembershipTypeDAOImpl(PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        this.service_ = service;
        this.orgService = orgService;
    }

    public final MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Date now = new Date();
        mt.setCreatedDate(now);
        mt.setModifiedDate(now);
        this.getIdentitySession().getRoleManager().createRoleType(mt.getName());
        this.updateMembershipType(mt);
        return mt;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Date now = new Date();
        mt.setModifiedDate(now);
        this.updateMembershipType(mt);
        return mt;
    }

    public MembershipType findMembershipType(String name) throws Exception {
        RoleType rt = this.getIdentitySession().getRoleManager().getRoleType(name);
        MembershipTypeImpl mt = null;
        if (rt != null) {
            mt = new MembershipTypeImpl(name, null, null);
            this.populateMembershipType((MembershipType)mt);
        }
        return mt;
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        MembershipType mt = this.findMembershipType(name);
        if (mt != null) {
            this.getIdentitySession().getRoleManager().removeRoleType(mt.getName());
        }
        return mt;
    }

    public Collection findMembershipTypes() throws Exception {
        Collection rts = this.getIdentitySession().getRoleManager().findRoleTypes();
        LinkedList<MembershipTypeImpl> mts = new LinkedList<MembershipTypeImpl>();
        for (RoleType rt : rts) {
            MembershipTypeImpl mt = new MembershipTypeImpl(rt.getName(), null, null);
            this.populateMembershipType((MembershipType)mt);
            mts.add(mt);
        }
        return mts;
    }

    private IdentitySession getIdentitySession() throws Exception {
        return this.service_.getIdentitySession();
    }

    private void updateMembershipType(MembershipType mt) throws Exception {
        RoleType rt = this.getIdentitySession().getRoleManager().getRoleType(mt.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(MEMBERSHIP_DESCRIPTION, mt.getDescription());
        props.put(MEMBERSHIP_CREATE_DATE, mt.getCreatedDate() == null ? null : dateFormat.format(mt.getCreatedDate()));
        props.put(MEMBERSHIP_MODIFIED_DATE, mt.getModifiedDate() == null ? null : dateFormat.format(mt.getModifiedDate()));
        props.put(MEMBERSHIP_OWNER, mt.getOwner());
        this.getIdentitySession().getRoleManager().setProperties(rt, props);
    }

    private void populateMembershipType(MembershipType mt) throws Exception {
        RoleType rt = this.getIdentitySession().getRoleManager().getRoleType(mt.getName());
        Map props = this.getIdentitySession().getRoleManager().getProperties(rt);
        mt.setDescription((String)props.get(MEMBERSHIP_DESCRIPTION));
        mt.setOwner((String)props.get(MEMBERSHIP_OWNER));
        String cd = (String)props.get(MEMBERSHIP_CREATE_DATE);
        String md = (String)props.get(MEMBERSHIP_MODIFIED_DATE);
        if (cd != null) {
            mt.setCreatedDate(dateFormat.parse(cd));
        }
        if (md != null) {
            mt.setModifiedDate(dateFormat.parse(md));
        }
    }
}

