/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.introspector.jlr;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.introspector.AnnotatedType;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.jlr.AbstractAnnotatedItem;
import org.jboss.webbeans.resources.ClassTransformer;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedType<T>
extends AbstractAnnotatedItem<T, Class<T>>
implements AnnotatedType<T> {
    private final AnnotatedClass<?> superclass;
    private final String name;
    private final String _simpleName;
    private String toString;
    private final boolean _public;

    public AbstractAnnotatedType(AnnotationStore annotatedItemHelper, Class<T> rawType, Type type, ClassTransformer classTransformer) {
        super(annotatedItemHelper, rawType, type);
        this.name = rawType.getName();
        this._simpleName = rawType.getSimpleName();
        this.superclass = rawType.getSuperclass() != null ? classTransformer.classForName(rawType.getSuperclass()) : null;
        this._public = Modifier.isFinal(rawType.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic((Class)this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal((Class)this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return this._public;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AnnotatedClass<?> getSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return ((Class)this.getDelegate()).equals(clazz);
    }

    @Override
    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = "Abstract annotated type " + this.getName();
        return this.toString;
    }

    @Override
    public String getSimpleName() {
        return this._simpleName;
    }
}

