/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.navtree;

import java.util.Vector;
import javax.management.ObjectName;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jboss.console.manager.interfaces.TreeInfo;
import org.jboss.console.navtree.NodeWrapper;
import org.jboss.console.navtree.RootWrapper;
import org.jboss.console.navtree.TreeContext;
import org.jboss.console.navtree.TreeReopenerMemory;

public class ConsoleTreeModel
implements TreeModel {
    protected TreeInfo tree = null;
    protected RootWrapper root = null;
    protected Vector treeModelListeners = new Vector();
    protected TreeContext context = null;
    protected TreeReopenerMemory reopenerMemory = null;
    protected ObjectName targetPM = null;

    public ConsoleTreeModel(TreeContext context) throws Exception {
        this.targetPM = new ObjectName(context.getServiceJmxName());
        this.context = context;
        this.tree = this.loadTree();
        this.root = new RootWrapper(this.tree);
    }

    public boolean refreshTree(boolean force) throws Exception {
        TreeInfo tmpTree = null;
        tmpTree = !force && this.tree != null ? this.conditionalLoadTree(this.tree.getTreeVersion()) : this.loadTree();
        if (tmpTree != null) {
            RootWrapper oldRoot = this.root;
            this.tree = tmpTree;
            this.root = new RootWrapper(this.tree);
            this.fireTreeStructureChanged(oldRoot);
            return true;
        }
        return false;
    }

    public TreeInfo conditionalLoadTree(long version) throws Exception {
        return (TreeInfo)this.context.getRemoteMBeanInvoker().invoke(this.targetPM, "getUpdateTreeForProfile", new Object[]{"WEB", new Long(version)}, new String[]{"java.lang.String", "long"});
    }

    public TreeInfo loadTree() throws Exception {
        return (TreeInfo)this.context.getRemoteMBeanInvoker().invoke(this.targetPM, "getTreeForProfile", new Object[]{"WEB"}, new String[]{"java.lang.String"});
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    public Object getChild(Object parent, int index) {
        NodeWrapper n = (NodeWrapper)parent;
        return n.getChild(index);
    }

    public int getChildCount(Object parent) {
        NodeWrapper n = (NodeWrapper)parent;
        return n.getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        NodeWrapper n = (NodeWrapper)parent;
        return n.getIndexOfChild(child);
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        NodeWrapper n = (NodeWrapper)node;
        return n.isLeaf();
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected void fireTreeStructureChanged(RootWrapper oldRoot) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < len; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
        }
    }
}

