/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.exoplatform.services.document.diff.DiffAlgorithm;
import org.exoplatform.services.document.diff.DiffService;
import org.exoplatform.services.document.diff.Revision;
import org.exoplatform.services.document.impl.diff.ToStringImpl;

public class DiffServiceImpl
extends ToStringImpl
implements DiffService {
    protected DiffAlgorithm algorithm;

    public DiffServiceImpl(DiffAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Revision diff(Object[] orig, Object[] rev) throws Exception {
        if (orig == null || rev == null) {
            throw new IllegalArgumentException();
        }
        return this.algorithm.diff(orig, rev);
    }

    public boolean compare(Object[] orig, Object[] rev) {
        if (orig.length != rev.length) {
            return false;
        }
        for (int i = 0; i < orig.length; ++i) {
            if (orig[i].equals(rev[i])) continue;
            return false;
        }
        return true;
    }

    public String arrayToString(Object[] o) {
        return this.arrayToString(o, NL);
    }

    public Object[] editAll(Object[] text) {
        Object[] result = new String[text.length];
        for (int i = 0; i < text.length; ++i) {
            result[i] = text[i] + " <edited>";
        }
        return result;
    }

    public Object[] randomEdit(Object[] text) {
        return this.randomEdit(text, text.length);
    }

    public Object[] randomEdit(Object[] text, long seed) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(text));
        Random r = new Random(seed);
        int nops = r.nextInt(10);
        for (int i = 0; i < nops; ++i) {
            boolean del = r.nextBoolean();
            int pos = r.nextInt(result.size() + 1);
            int len = Math.min(result.size() - pos, 1 + r.nextInt(4));
            if (del && result.size() > 0) {
                result.subList(pos, pos + len).clear();
                continue;
            }
            int k = 0;
            while (k < len) {
                result.add(pos, "[" + i + "] random edit[" + i + "][" + i + "]");
                ++k;
                ++pos;
            }
        }
        return result.toArray();
    }

    public Object[] shuffle(Object[] text) {
        return this.shuffle(text, text.length);
    }

    public Object[] shuffle(Object[] text, long seed) {
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList(text));
        Collections.shuffle(result);
        return result.toArray();
    }

    public Object[] randomSequence(int size) {
        return this.randomSequence(size, size);
    }

    public Object[] randomSequence(int size, long seed) {
        Object[] result = new Integer[size];
        Random r = new Random(seed);
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Integer(r.nextInt(size));
        }
        return result;
    }
}

