/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api.session.managers;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySearchCriteriumType;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.PersistenceManager;
import org.picketlink.idm.api.PersistenceManagerFeaturesDescription;
import org.picketlink.idm.api.User;
import org.picketlink.idm.cache.GroupSearch;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.model.GroupKey;
import org.picketlink.idm.impl.api.model.SimpleGroup;
import org.picketlink.idm.impl.api.model.SimpleUser;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.managers.AbstractManager;
import org.picketlink.idm.impl.cache.GroupSearchImpl;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.model.IdentityObjectType;
import org.picketlink.idm.spi.store.IdentityObjectSearchCriteriaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceManagerImpl
extends AbstractManager
implements PersistenceManager,
Serializable {
    private final PersistenceManagerFeaturesDescription featuresDescription = new PersistenceManagerFeaturesDescription(){

        public boolean isUsersAddRemoveSupported() {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isGroupsAddRemoveSupported(String groupType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
        }

        public boolean isUsersSearchCriteriumTypeSupported(IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType();
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf((String)constraintType.name());
            if (constraint != null) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }

        public boolean isGroupsSearchCriteriumTypeSupported(String groupType, IdentitySearchCriteriumType constraintType) {
            IdentityObjectType objectType = PersistenceManagerImpl.this.getSessionContext().getIdentityObjectTypeMapper().getIdentityObjectType(groupType);
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf((String)constraintType.name());
            if (constraint != null) {
                return PersistenceManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isSearchCriteriaTypeSupported(objectType, constraint);
            }
            return false;
        }
    };
    private static final long serialVersionUID = -4691446225503953920L;

    public PersistenceManagerImpl(IdentitySessionImpl session) {
        super(session);
    }

    public PersistenceManagerFeaturesDescription getFeaturesDescription() {
        return this.featuresDescription;
    }

    public User createUser(String identityName) throws IdentityException {
        this.checkNotNullArgument(identityName, "Identity name");
        this.checkObjectName(identityName);
        IdentityObjectType iot = this.getUserObjectType();
        this.preCreate((IdentityType)new SimpleUser(identityName));
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), identityName, iot);
        SimpleUser user = null;
        if (identityObject != null) {
            user = new SimpleUser(identityName);
        }
        if (this.cache != null) {
            this.cache.invalidate(this.cacheNS);
            this.cache.putUser(this.cacheNS, (User)user);
        }
        this.postCreate((IdentityType)user);
        return user;
    }

    public Group createGroup(String groupName, String groupType) throws IdentityException {
        this.checkNotNullArgument(groupName, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        this.checkObjectName(groupName);
        this.checkObjectName(groupType);
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        this.preCreate((IdentityType)new SimpleGroup(groupName, groupType));
        IdentityObject identityObject = this.getRepository().createIdentityObject(this.getInvocationContext(), groupName, iot);
        SimpleGroup group = null;
        if (identityObject != null) {
            group = new SimpleGroup(groupName, groupType);
        }
        if (this.cache != null) {
            this.cache.invalidate(this.cacheNS);
            this.cache.putGroup(this.cacheNS, (Group)group);
        }
        this.postCreate((IdentityType)new SimpleGroup(groupName, groupType));
        return group;
    }

    public String createGroupKey(String groupName, String groupType) {
        this.checkNotNullArgument(groupName, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        this.checkObjectName(groupName);
        this.checkObjectName(groupType);
        return new GroupKey(groupName, groupType).getKey();
    }

    public String createUserKey(String id) {
        return id;
    }

    public void removeUser(User user, boolean force) throws IdentityException {
        this.checkNotNullArgument(user, "User");
        this.preRemove((IdentityType)user);
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(user));
        if (this.cache != null) {
            this.cache.invalidate(this.cacheNS);
        }
        this.postRemove((IdentityType)user);
    }

    public void removeUser(String userName, boolean force) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.preRemove((IdentityType)new SimpleUser(userName));
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObjectForUserName(userName));
        if (this.cache != null) {
            this.cache.invalidate(this.cacheNS);
        }
        this.postRemove((IdentityType)new SimpleUser(userName));
    }

    public void removeGroup(Group group, boolean force) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        this.preRemove((IdentityType)group);
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObject(group));
        if (this.cache != null) {
            this.cache.invalidate(this.cacheNS);
        }
        this.postRemove((IdentityType)group);
    }

    public void removeGroup(String groupId, boolean force) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        this.preRemove((IdentityType)new SimpleGroup(new GroupKey(groupId)));
        this.getRepository().removeIdentityObject(this.getInvocationContext(), this.createIdentityObjectForGroupId(groupId));
        if (this.cache != null) {
            this.cache.invalidate(this.cacheNS);
        }
        this.postRemove((IdentityType)new SimpleGroup(new GroupKey(groupId)));
    }

    public int getUserCount() throws IdentityException {
        int count;
        if (this.cache != null && (count = this.cache.getUserCount(this.cacheNS)) != -1) {
            return count;
        }
        IdentityObjectType iot = this.getUserObjectType();
        int count2 = this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
        if (this.cache != null) {
            this.cache.putUserCount(this.cacheNS, count2);
        }
        return count2;
    }

    public int getGroupTypeCount(String groupType) throws IdentityException {
        int count;
        this.checkNotNullArgument(groupType, "Group type");
        if (this.cache != null && (count = this.cache.getGroupCount(this.cacheNS, groupType)) != -1) {
            return count;
        }
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        int count2 = this.getRepository().getIdentityObjectsCount(this.getInvocationContext(), iot);
        if (this.cache != null) {
            this.cache.putGroupCount(this.cacheNS, groupType, count2);
        }
        return count2;
    }

    public User findUser(String name) throws IdentityException {
        User user;
        this.checkNotNullArgument(name, "User name");
        if (this.cache != null && (user = this.cache.getUser(this.cacheNS, name)) != null) {
            return user;
        }
        IdentityObject io = this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getUserObjectType());
        if (io != null) {
            User user2 = this.createUser(io);
            if (this.cache != null) {
                this.cache.putUser(this.cacheNS, user2);
            }
            return user2;
        }
        return null;
    }

    public Collection<User> findUser(IdentitySearchCriteria criteria) throws IdentityException {
        Collection users;
        if (this.cache != null && (users = this.cache.getUsers(this.cacheNS, criteria)) != null) {
            return users;
        }
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getUserObjectType(), this.convertSearchControls(criteria));
        LinkedList<User> identities = new LinkedList<User>();
        for (IdentityObject identityObject : ios) {
            identities.add(this.createUser(identityObject));
        }
        if (this.cache != null) {
            this.cache.putUsers(this.cacheNS, criteria, identities);
        }
        return identities;
    }

    public Group findGroup(String name, String groupType) throws IdentityException {
        Group group;
        this.checkNotNullArgument(name, "Group name");
        this.checkNotNullArgument(groupType, "Group type");
        if (this.cache != null && (group = this.cache.getGroup(this.cacheNS, groupType, name)) != null) {
            return group;
        }
        IdentityObject io = this.getRepository().findIdentityObject(this.getInvocationContext(), name, this.getIdentityObjectType(groupType));
        if (io != null) {
            Group group2 = this.createGroup(io);
            if (this.cache != null) {
                this.cache.putGroup(this.cacheNS, group2);
            }
            return group2;
        }
        return null;
    }

    public Group findGroupByKey(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Group id");
        if (!GroupKey.validateKey(id)) {
            throw new IdentityException("Provided group id is not valid: " + id + "; " + "Please use PersistenceManager.createGroupKey() to obtain valid group id");
        }
        GroupKey groupKey = new GroupKey(id);
        return this.findGroup(groupKey.getName(), groupKey.getType());
    }

    public Collection<Group> findGroup(String groupType, IdentitySearchCriteria criteria) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            Collection results = this.cache.getGroupSearch(this.cacheNS, (GroupSearch)search);
            if (results != null) {
                return results;
            }
        }
        Collection ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.getIdentityObjectType(groupType), this.convertSearchControls(criteria));
        LinkedList<Group> groups = new LinkedList<Group>();
        for (IdentityObject identityObject : ios) {
            groups.add(this.createGroup(identityObject));
        }
        if (this.cache != null) {
            GroupSearchImpl search = new GroupSearchImpl();
            search.setGroupType(groupType);
            search.setSearchCriteria(criteria);
            this.cache.putGroupSearch(this.cacheNS, (GroupSearch)search, groups);
        }
        return groups;
    }

    public Collection<Group> findGroup(String groupType) throws IdentityException {
        this.checkNotNullArgument(groupType, "Group type");
        return this.findGroup(groupType, (IdentitySearchCriteria)null);
    }
}

