/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.common.jcr;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ks.common.conf.DataLocationPlugin;
import org.exoplatform.ks.common.jcr.JCRSessionManager;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class KSDataLocation {
    private static final Log log = ExoLogger.getLogger(KSDataLocation.class);
    public static final String REPOSITORY_PARAM = "repository";
    public static final String WORKSPACE_PARAM = "workspace";
    public static final String DEFAULT_REPOSITORY_NAME = "repository";
    public static final String DEFAULT_WORKSPACE_NAME = "portal-system";
    private String forumHomeLocation;
    private String forumDataLocation;
    private String topicTypesLocation;
    private String forumSystemLocation;
    private String banIPLocation;
    private String statisticsLocation;
    private String administrationLocation;
    private String userProfilesLocation;
    private String forumCategoriesLocation;
    private String tagsLocation;
    private String avatarsLocation;
    private String forumBanIPLocation;
    private String bbcodesLocation;
    private String faqHomeLocation;
    private String forumStatisticsLocation;
    private String faqSettingsLocation;
    private String faqUserSettingsLocation;
    private String faqCategoriesLocation;
    private String faqTemplatesLocation;
    private NodeHierarchyCreator creator;
    private String repository;
    private String workspace;
    private SessionManager sessionManager;

    public KSDataLocation(InitParams params, NodeHierarchyCreator creator) {
        this.creator = creator;
        this.repository = this.getParam(params, "repository", "repository");
        this.workspace = this.getParam(params, WORKSPACE_PARAM, DEFAULT_WORKSPACE_NAME);
        this.sessionManager = new JCRSessionManager(this.repository, this.workspace);
        this.initPathes();
    }

    public KSDataLocation(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
        this.sessionManager = new JCRSessionManager(repository, workspace);
        this.initPathes();
    }

    private void initPathes() {
        this.forumHomeLocation = this.getPath("ForumService");
        this.avatarsLocation = this.getPath("ksUserAvatar");
        this.forumSystemLocation = this.getPath("ForumSystem");
        this.userProfilesLocation = this.getPath("UserProfileHome");
        this.statisticsLocation = this.getPath("StatisticHome");
        this.forumStatisticsLocation = this.getPath("forumStatistic");
        this.administrationLocation = this.getPath("AdministrationHome");
        this.banIPLocation = this.getPath("BanIPHome");
        this.forumBanIPLocation = this.getPath("forumBanIP");
        this.forumDataLocation = this.getPath("ForumData");
        this.topicTypesLocation = this.getPath("TopicTypeHome");
        this.forumCategoriesLocation = this.getPath("CategoryHome");
        this.tagsLocation = this.getPath("TagHome");
        this.bbcodesLocation = this.getPath("forumBBCode");
        this.faqHomeLocation = this.getPath("faqApp");
        this.faqSettingsLocation = this.getPath("settingHome");
        this.faqUserSettingsLocation = this.getPath("userSettingHome");
        this.faqCategoriesLocation = this.getPath("categories");
        this.faqTemplatesLocation = this.getPath("templateHome");
    }

    public void setLocation(DataLocationPlugin plugin) {
        this.repository = plugin.getRepository();
        this.workspace = plugin.getWorkspace();
        this.sessionManager = new JCRSessionManager(this.repository, this.workspace);
    }

    protected String getPath(String locationName) {
        if (this.creator == null) {
            return locationName;
        }
        String path = this.creator.getJcrPath(locationName);
        if (path != null) {
            path = path.substring(1);
        }
        return path;
    }

    private String getParam(InitParams params, String name, String defaultValue) {
        String result = null;
        try {
            result = params.getValueParam(name).getValue();
        }
        catch (Exception e) {
            log.warn((Object)("No '" + name + "' value-param. Using default value: " + defaultValue));
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager manager) {
        this.sessionManager = manager;
    }

    public String getForumHomeLocation() {
        return this.forumHomeLocation;
    }

    public String getForumDataLocation() {
        return this.forumDataLocation;
    }

    public String getTopicTypesLocation() {
        return this.topicTypesLocation;
    }

    public String getForumSystemLocation() {
        return this.forumSystemLocation;
    }

    public String getBanIPLocation() {
        return this.banIPLocation;
    }

    public String getStatisticsLocation() {
        return this.statisticsLocation;
    }

    public String getAdministrationLocation() {
        return this.administrationLocation;
    }

    public String getUserProfilesLocation() {
        return this.userProfilesLocation;
    }

    public String getForumCategoriesLocation() {
        return this.forumCategoriesLocation;
    }

    public String getTagsLocation() {
        return this.tagsLocation;
    }

    public String getAvatarsLocation() {
        return this.avatarsLocation;
    }

    public String getForumBanIPLocation() {
        return this.forumBanIPLocation;
    }

    public String getBBCodesLocation() {
        return this.bbcodesLocation;
    }

    public String getFaqHomeLocation() {
        return this.faqHomeLocation;
    }

    public String getFaqSettingsLocation() {
        return this.faqSettingsLocation;
    }

    public String getFaqUserSettingsLocation() {
        return this.faqUserSettingsLocation;
    }

    public String getFaqCategoriesLocation() {
        return this.faqCategoriesLocation;
    }

    public String getFaqTemplatesLocation() {
        return this.faqTemplatesLocation;
    }

    public String getForumStatisticsLocation() {
        return this.forumStatisticsLocation;
    }

    public String toString() {
        return this.repository + "/" + this.workspace;
    }

    public String getUserSubscriptionLocation(String userId) {
        return this.getUserProfilesLocation() + "/" + userId + "/forumSubscription" + userId;
    }

    public static interface Locations {
        public static final String FORUM_STATISTIC = "forumStatistic";
        public static final String TEMPLATE_HOME = "templateHome";
        public static final String USER_SETTING_HOME = "userSettingHome";
        public static final String SETTING_HOME = "settingHome";
        public static final String FAQ_SERVICE = "faqApp";
        public static final String USER_PROFILE_HOME = "UserProfileHome";
        public static final String ADMINISTRATION_HOME = "AdministrationHome";
        public static final String STATISTIC_HOME = "StatisticHome";
        public static final String BANIP_HOME = "BanIPHome";
        public static final String FORUM_BAN_IP = "forumBanIP";
        public static final String TOPIC_TYPE_HOME = "TopicTypeHome";
        public static final String TAG_HOME = "TagHome";
        public static final String FAQ_CATEGORIES_HOME = "categories";
        public static final String FORUM_CATEGORIES_HOME = "CategoryHome";
        public static final String KS_USER_AVATAR = "ksUserAvatar";
        public static final String BBCODE_HOME = "forumBBCode";
        public static final String FORUM_DATA = "ForumData";
        public static final String FORUM_SYSTEM = "ForumSystem";
        public static final String FORUM_SERVICE = "ForumService";
        public static final String DEFAULT_APPS_LOCATION = "exo:applications";
    }
}

