/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.impl.InternalException;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.impl.method.ParameterResolverFactory;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.resource.GenericMethodResource;

public final class DefaultMethodInvoker
implements MethodInvoker {
    private static final Log LOG = ExoLogger.getLogger((String)DefaultMethodInvoker.class.getName());

    public Object invokeMethod(Object resource, GenericMethodResource methodResource, ApplicationContext context) {
        for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getMethodInvokerFilters(context.getPath())) {
            MethodInvokerFilter f = (MethodInvokerFilter)factory.getInstance(context);
            f.accept(methodResource);
        }
        Object[] p = new Object[methodResource.getMethodParameters().size()];
        int i = 0;
        for (MethodParameter mp : methodResource.getMethodParameters()) {
            Annotation a = mp.getAnnotation();
            if (a != null) {
                ParameterResolver pr = ParameterResolverFactory.createParameterResolver(a);
                try {
                    p[i++] = pr.resolve(mp, context);
                    continue;
                }
                catch (Exception e) {
                    Class<? extends Annotation> ac = a.annotationType();
                    if (ac == MatrixParam.class || ac == QueryParam.class || ac == PathParam.class) {
                        throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                    }
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
                }
            }
            InputStream entityStream = context.getContainerRequest().getEntityStream();
            if (entityStream == null) {
                p[i++] = null;
                continue;
            }
            MediaType contentType = context.getContainerRequest().getMediaType();
            MultivaluedMap headers = context.getContainerRequest().getRequestHeaders();
            MessageBodyReader<?> entityReader = context.getProviders().getMessageBodyReader(mp.getParameterClass(), mp.getGenericType(), mp.getAnnotations(), contentType);
            if (entityReader == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)"Unsupported media type. ");
                }
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).build());
            }
            try {
                p[i++] = entityReader.readFrom(mp.getParameterClass(), mp.getGenericType(), mp.getAnnotations(), contentType, headers, entityStream);
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new InternalException(e);
            }
        }
        try {
            return methodResource.getMethod().invoke(resource, p);
        }
        catch (IllegalArgumentException argExc) {
            throw new InternalException(argExc);
        }
        catch (IllegalAccessException accessExc) {
            throw new InternalException(accessExc);
        }
        catch (InvocationTargetException invExc) {
            Throwable cause;
            if (LOG.isDebugEnabled()) {
                invExc.printStackTrace();
            }
            if (WebApplicationException.class == (cause = invExc.getCause()).getClass()) {
                throw (WebApplicationException)cause;
            }
            throw new InternalException(cause);
        }
    }
}

