/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement.composite;

import java.io.Serializable;
import org.rhq.core.domain.measurement.MeasurementDataNumeric1H;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.util.MeasurementConverter;

public class MeasurementOOBComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String resourceName;
    private int resourceId;
    private String scheduleName;
    private int scheduleId;
    private long timestamp;
    private int definitionId;
    private int factor;
    private double blMin;
    private double blMax;
    private double dataMin;
    private double dataMax;
    private double outlier;
    private MeasurementUnits units;
    private String parentName;
    private Integer parentId;

    public MeasurementOOBComposite(String resourceName, int resourceId, String scheduleName, int scheduleId, long timestamp, int definitionId, int factor, double blMin, double blMax, MeasurementUnits units, String parentName, Integer parentId) {
        this.resourceName = resourceName;
        this.resourceId = resourceId;
        this.scheduleName = scheduleName;
        this.scheduleId = scheduleId;
        this.definitionId = definitionId;
        this.factor = factor;
        this.blMin = blMin;
        this.blMax = blMax;
        this.timestamp = timestamp;
        this.units = units;
        this.parentId = parentId;
        this.parentName = parentName;
    }

    public MeasurementOOBComposite(String resourceName, int resourceId, String scheduleName, int scheduleId, long timestamp, int definitionId, int factor, double blMin, double blMax, MeasurementUnits unit) {
        this.resourceName = resourceName;
        this.resourceId = resourceId;
        this.scheduleName = scheduleName;
        this.scheduleId = scheduleId;
        this.definitionId = definitionId;
        this.factor = factor;
        this.blMin = blMin;
        this.blMax = blMax;
        this.timestamp = timestamp;
        this.units = unit;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public int getScheduleId() {
        return this.scheduleId;
    }

    public int getDefinitionId() {
        return this.definitionId;
    }

    public int getFactor() {
        return this.factor;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public double getBlMin() {
        return this.blMin;
    }

    public double getBlMax() {
        return this.blMax;
    }

    public double getDataMin() {
        return this.dataMin;
    }

    public double getDataMax() {
        return this.dataMax;
    }

    public String getParentName() {
        return this.parentName;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public void setDataMin(double dataMin) {
        this.dataMin = dataMin;
    }

    public void setDataMax(double dataMax) {
        this.dataMax = dataMax;
    }

    public void setData(MeasurementDataNumeric1H data) {
        this.dataMin = data.getMin();
        this.dataMax = data.getMax();
    }

    public double getOutlier() {
        return this.outlier;
    }

    public void setOutlier(double outlier) {
        this.outlier = outlier;
    }

    public void calculateOutlier() {
        this.outlier = this.blMin - this.dataMin < this.dataMax - this.blMax ? this.dataMax : this.dataMin;
    }

    public String getFormattedBaseband() {
        String min = MeasurementConverter.format(this.blMin, this.units, true);
        String max = MeasurementConverter.format(this.blMax, this.units, true);
        String result = min + ", " + max;
        return result;
    }

    public String getFormattedOutlier() {
        return MeasurementConverter.format(this.outlier, this.units, true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MeasurementOOBComposite");
        sb.append("{resourceName='").append(this.resourceName).append('\'');
        sb.append(", resourceId=").append(this.resourceId);
        sb.append(", scheduleName='").append(this.scheduleName).append('\'');
        sb.append(", scheduleId=").append(this.scheduleId);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", definitionId=").append(this.definitionId);
        sb.append(", factor=").append(this.factor);
        sb.append(", blMin=").append(this.blMin);
        sb.append(", blMax=").append(this.blMax);
        sb.append(", dataMin=").append(this.dataMin);
        sb.append(", dataMax=").append(this.dataMax);
        sb.append(", outlier=").append(this.outlier);
        sb.append(", units=").append((Object)this.units);
        sb.append(", parentName='").append(this.parentName).append('\'');
        sb.append(", parentId=").append(this.parentId);
        sb.append('}');
        return sb.toString();
    }
}

