/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentation;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;

public class JcrURLConnection
extends URLConnection {
    private Session session;
    private NodeRepresentationService nodeRepresentationService;
    private UnifiedNodeReference nodeReference;
    private NodeRepresentation nodeRepresentation;

    public JcrURLConnection(UnifiedNodeReference nodeReference, Session session, NodeRepresentationService nodeRepresentationService) throws MalformedURLException {
        super(nodeReference.getURL());
        this.session = session;
        this.nodeReference = nodeReference;
        this.nodeRepresentationService = nodeRepresentationService;
        this.doOutput = false;
        this.allowUserInteraction = false;
        this.useCaches = false;
        this.ifModifiedSince = 0L;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        try {
            Node node = null;
            if (this.nodeReference.isPath()) {
                node = this.session.getRootNode().getNode(this.nodeReference.getPath().substring(1));
            } else if (this.nodeReference.isIdentitifier()) {
                node = this.session.getNodeByUUID(this.nodeReference.getIdentitifier().getString());
            } else {
                throw new IllegalArgumentException("Absolute path or Identifier was not found!");
            }
            this.nodeRepresentation = this.nodeRepresentationService.getNodeRepresentation(node, "text/xml");
            this.connected = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Connection refused!");
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.nodeRepresentation.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("can't get input stream");
        }
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.nodeRepresentation.getNode();
    }

    public Object getContent(Class[] classes) throws IOException {
        throw new UnsupportedOperationException("protocol support only javax.jcr.Node as content, use method getContent() instead this.");
    }

    public String getContentType() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.nodeRepresentation.getMediaType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getContentLength() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return (int)this.nodeRepresentation.getContentLenght();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setDoOutput(boolean dooutput) {
        if (dooutput) {
            throw new UnsupportedOperationException("protocol doesn't support output!");
        }
        super.setDoOutput(dooutput);
    }

    public String getContentEncoding() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.nodeRepresentation.getContentEncoding();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getLastModified() {
        try {
            return this.nodeRepresentation.getLastModified();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        if (allowuserinteraction) {
            throw new UnsupportedOperationException("protocol doesn't support user interaction!");
        }
        super.setAllowUserInteraction(allowuserinteraction);
    }

    public void setUseCaches(boolean usecaches) {
        if (usecaches) {
            throw new UnsupportedOperationException("protocol doesn't support caches!");
        }
        super.setUseCaches(usecaches);
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        if (ifmodifiedsince > 0L) {
            throw new UnsupportedOperationException("protocol doesn't support this feature!");
        }
        super.setIfModifiedSince(ifmodifiedsince);
    }

    public void addRequestProperty(String key, String value) {
        throw new UnsupportedOperationException("protocol doesn't support request properties!");
    }

    public void setRequestProperty(String key, String value) {
        throw new UnsupportedOperationException("protocol doesn't support request properties!");
    }
}

