/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.lock.AbstractSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.LockImpl;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;

public class SessionLockManagerImpl
extends AbstractSessionLockManager {
    private final String sessionId;
    private final LockManagerImpl lockManager;

    public SessionLockManagerImpl(String sessionId, LockManagerImpl lockManager, SessionDataManager transientManager) {
        super(transientManager);
        this.sessionId = sessionId;
        this.lockManager = lockManager;
    }

    public Lock addLock(NodeImpl node, boolean isDeep, boolean isSessionScoped, long timeOut) throws LockException, RepositoryException {
        return this.lockManager.addPendingLock(node, isDeep, isSessionScoped, timeOut);
    }

    public void addLockToken(String lt) {
        this.lockManager.addLockToken(this.sessionId, lt);
    }

    public LockImpl getLock(NodeImpl node) throws LockException, RepositoryException {
        return this.lockManager.getLock(node);
    }

    public String[] getLockTokens() {
        return this.lockManager.getLockTokens(this.sessionId);
    }

    public boolean holdsLock(NodeData node) throws RepositoryException {
        return this.lockManager.holdsLock(node);
    }

    protected boolean isPersitedLockHolder(NodeImpl node) throws RepositoryException {
        return this.lockManager.isLockHolder(node);
    }

    protected boolean isLockedPersisted(NodeData node) throws LockException {
        return this.lockManager.isLocked(node);
    }

    public void removeLockToken(String lt) {
        this.lockManager.removeLockToken(this.sessionId, lt);
    }

    public void onCloseSession(ExtendedSession session) {
        this.lockManager.onCloseSession(session);
    }
}

