/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerIoModeHandler {
    private static final Logger log = LoggerFactory.getLogger(IndexerIoModeHandler.class);
    private volatile IndexerIoMode mode;
    private final List<IndexerIoModeListener> listeners;

    public IndexerIoModeHandler(IndexerIoMode mode) {
        log.info("Indexer io mode=" + (Object)((Object)mode));
        this.mode = mode;
        this.listeners = new CopyOnWriteArrayList<IndexerIoModeListener>();
    }

    public IndexerIoMode getMode() {
        return this.mode;
    }

    public void setMode(IndexerIoMode mode) {
        if (this.mode != mode) {
            log.info("Indexer io mode=" + (Object)((Object)mode));
            this.mode = mode;
            for (IndexerIoModeListener listener : this.listeners) {
                listener.onChangeMode(mode);
            }
        }
    }

    public void addIndexerIoModeListener(IndexerIoModeListener listener) {
        this.listeners.add(listener);
    }
}

