/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.query.InvalidQueryException;
import org.exoplatform.services.jcr.impl.core.query.QueryTreeBuilder;
import org.exoplatform.services.jcr.impl.core.query.xpath.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTreeBuilderRegistry {
    private static final Logger log = LoggerFactory.getLogger(QueryTreeBuilderRegistry.class);
    private static final List<QueryTreeBuilder> BUILDERS = new ArrayList<QueryTreeBuilder>();
    private static final Set<String> LANGUAGES;

    public static QueryTreeBuilder getQueryTreeBuilder(String language) throws InvalidQueryException {
        for (int i = 0; i < BUILDERS.size(); ++i) {
            QueryTreeBuilder builder = BUILDERS.get(i);
            if (!builder.canHandle(language)) continue;
            return builder;
        }
        throw new InvalidQueryException("Unsupported language: " + language);
    }

    public static String[] getSupportedLanguages() {
        return LANGUAGES.toArray(new String[LANGUAGES.size()]);
    }

    static {
        HashSet<String> languages = new HashSet<String>();
        try {
            BUILDERS.add(new org.exoplatform.services.jcr.impl.core.query.sql.QueryBuilder());
            BUILDERS.add(new QueryBuilder());
            for (QueryTreeBuilder builder : BUILDERS) {
                languages.addAll(Arrays.asList(builder.getSupportedLanguages()));
            }
            if (BUILDERS.size() < 1) {
                log.warn("No builders found");
            }
        }
        catch (Error e) {
            log.warn("Unable to load providers for QueryTreeBuilder: " + e);
        }
        LANGUAGES = Collections.unmodifiableSet(languages);
    }
}

