/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.JCRPathMatcher;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.value.DateValue;
import org.exoplatform.services.jcr.impl.core.value.DoubleValue;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.ReferenceValue;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ValueConstraintsMatcher {
    protected static Log log = ExoLogger.getLogger((String)"jcr.ValueConstraintsMatcher");
    protected static final String DEFAULT_THRESHOLD = "";
    private final String[] constraints;
    private final LocationFactory locator;
    private final ItemDataConsumer itemDataConsumer;
    private final NodeTypeDataManager nodeTypeDataManager;

    public ValueConstraintsMatcher(String[] constraints, LocationFactory locator, ItemDataConsumer itemDataConsumer, NodeTypeDataManager nodeTypeDataManager) {
        this.constraints = constraints;
        this.locator = locator;
        this.itemDataConsumer = itemDataConsumer;
        this.nodeTypeDataManager = nodeTypeDataManager;
    }

    public boolean match(ValueData value, int type) throws ConstraintViolationException, IllegalStateException, RepositoryException {
        if (this.constraints == null || this.constraints.length <= 0) {
            return true;
        }
        boolean invalid = true;
        ValueData valueData = value;
        if (type == 1) {
            try {
                String strVal = new String(valueData.getAsByteArray(), "UTF-8");
                for (int i = 0; invalid && i < this.constraints.length; ++i) {
                    String constrString = this.constraints[i];
                    if (!strVal.matches(constrString)) continue;
                    invalid = false;
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("FATAL ERROR Charset UTF-8 is not supported!");
            }
            catch (IOException e) {
                throw new RepositoryException("FATAL ERROR Value data stream reading error " + e.getMessage(), (Throwable)e);
            }
        }
        if (type == 7) {
            NameValue nameVal;
            try {
                nameVal = new NameValue(valueData, this.locator);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            for (int i = 0; invalid && i < this.constraints.length; ++i) {
                String constrString = this.constraints[i];
                InternalQName constrName = this.locator.parseJCRName(constrString).getInternalName();
                if (!nameVal.getQName().equals((Object)constrName)) continue;
                invalid = false;
            }
        } else if (type == 8) {
            PathValue pathVal;
            try {
                pathVal = new PathValue(valueData, this.locator);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            for (int i = 0; invalid && i < this.constraints.length; ++i) {
                String constrString = this.constraints[i];
                JCRPathMatcher constrPath = this.parsePathMatcher(this.locator, constrString);
                if (!constrPath.match(pathVal.getQPath())) continue;
                invalid = false;
            }
        } else if (type == 9) {
            try {
                ReferenceValue refVal = new ReferenceValue(valueData);
                NodeData refNode = (NodeData)this.itemDataConsumer.getItemData(refVal.getIdentifier().getString());
                for (int i = 0; invalid && i < this.constraints.length; ++i) {
                    String constrString = this.constraints[i];
                    InternalQName constrName = this.locator.parseJCRName(constrString).getInternalName();
                    if (!this.nodeTypeDataManager.isNodeType(constrName, refNode.getPrimaryTypeName(), refNode.getMixinTypeNames())) continue;
                    invalid = false;
                }
            }
            catch (ItemNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reference constraint node is not found: " + e.getMessage()));
                }
                invalid = false;
            }
            catch (RepositoryException e) {
                log.error((Object)("Reference constraint error: " + e.getMessage()), (Throwable)e);
                invalid = true;
            }
            catch (IOException e) {
                log.error((Object)("Reference constraint error: " + e.getMessage()), (Throwable)e);
                invalid = true;
            }
        } else if (type == 2) {
            long valueLength = valueData.getLength();
            for (int i = 0; invalid && i < this.constraints.length; ++i) {
                long max;
                long min;
                String constrString = this.constraints[i];
                boolean minInvalid = true;
                boolean maxInvalid = true;
                MinMaxConstraint constraint = this.parseAsMinMax(constrString);
                long l = min = constraint.getMin().getThreshold().length() > 0 ? new Long(constraint.getMin().getThreshold()) : Long.MIN_VALUE;
                if (constraint.getMin().isExclusive()) {
                    if (valueLength > min) {
                        minInvalid = false;
                    }
                } else if (valueLength >= min) {
                    minInvalid = false;
                }
                long l2 = max = constraint.getMax().getThreshold().length() > 0 ? new Long(constraint.getMax().getThreshold()) : Long.MAX_VALUE;
                if (constraint.getMax().isExclusive()) {
                    if (valueLength < max) {
                        maxInvalid = false;
                    }
                } else if (valueLength <= max) {
                    maxInvalid = false;
                }
                invalid = maxInvalid | minInvalid;
            }
        } else if (type == 5) {
            Calendar valueCalendar;
            try {
                valueCalendar = new DateValue(valueData).getDate();
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            for (int i = 0; invalid && i < this.constraints.length; ++i) {
                String constrString = this.constraints[i];
                boolean minInvalid = true;
                boolean maxInvalid = true;
                MinMaxConstraint constraint = this.parseAsMinMax(constrString);
                try {
                    if (constraint.getMin().getThreshold().length() > 0) {
                        Calendar min = JCRDateFormat.parse(constraint.getMin().getThreshold());
                        if (constraint.getMin().isExclusive()) {
                            if (valueCalendar.compareTo(min) > 0) {
                                minInvalid = false;
                            }
                        } else if (valueCalendar.compareTo(min) >= 0) {
                            minInvalid = false;
                        }
                    } else {
                        minInvalid = false;
                    }
                }
                catch (ValueFormatException e) {
                    minInvalid = false;
                }
                try {
                    if (constraint.getMax().getThreshold().length() > 0) {
                        Calendar max = JCRDateFormat.parse(constraint.getMax().getThreshold());
                        if (constraint.getMax().isExclusive()) {
                            if (valueCalendar.compareTo(max) < 0) {
                                maxInvalid = false;
                            }
                        } else if (valueCalendar.compareTo(max) <= 0) {
                            maxInvalid = false;
                        }
                    } else {
                        maxInvalid = false;
                    }
                }
                catch (ValueFormatException e) {
                    maxInvalid = false;
                }
                invalid = maxInvalid | minInvalid;
            }
        } else if (type == 3 || type == 4) {
            Double valueNumber;
            try {
                valueNumber = new DoubleValue(valueData).getDouble();
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            for (int i = 0; invalid && i < this.constraints.length; ++i) {
                String constrString = this.constraints[i];
                boolean minInvalid = true;
                boolean maxInvalid = true;
                MinMaxConstraint constraint = this.parseAsMinMax(constrString);
                Double min = constraint.getMin().getThreshold().length() > 0 ? new Double(constraint.getMin().getThreshold()) : Double.MIN_VALUE;
                if (constraint.getMin().isExclusive()) {
                    if (valueNumber > min) {
                        minInvalid = false;
                    }
                } else if (valueNumber >= min) {
                    minInvalid = false;
                }
                Double max = constraint.getMax().getThreshold().length() > 0 ? new Double(constraint.getMax().getThreshold()) : Double.MAX_VALUE;
                if (constraint.getMax().isExclusive()) {
                    if (valueNumber < max) {
                        maxInvalid = false;
                    }
                } else if (valueNumber <= max) {
                    maxInvalid = false;
                }
                invalid = maxInvalid | minInvalid;
            }
        } else if (type == 6) {
            invalid = false;
        }
        return !invalid;
    }

    JCRPath parsePath(String path, LocationFactory locFactory) throws RepositoryException {
        try {
            return locFactory.parseAbsPath(path);
        }
        catch (RepositoryException e) {
            try {
                return locFactory.parseRelPath(path);
            }
            catch (RepositoryException e1) {
                throw e;
            }
        }
    }

    protected MinMaxConstraint parseAsMinMax(String constraint) throws ConstraintViolationException {
        String[] parts = constraint.split(",");
        if (parts.length != 2) {
            throw new ConstraintViolationException("Value constraint '" + constraint + "' is invalid accrding the JSR-170 spec.");
        }
        boolean exclusive = false;
        if (parts[0].startsWith("(")) {
            exclusive = true;
        } else if (parts[0].startsWith("[")) {
            exclusive = false;
        } else {
            throw new ConstraintViolationException("Value constraint '" + constraint + "' min exclusion rule is unefined accrding the JSR-170 spec.");
        }
        ConstraintRange minValue = new ConstraintRange(parts[0].length() > 1 ? parts[0].substring(1) : DEFAULT_THRESHOLD, exclusive);
        if (parts[1].endsWith(")")) {
            exclusive = true;
        } else if (parts[1].endsWith("]")) {
            exclusive = false;
        } else {
            throw new ConstraintViolationException("Value constraint '" + constraint + "' max exclusion rule is unefined accrding the JSR-170 spec.");
        }
        ConstraintRange maxValue = new ConstraintRange(parts[1].length() > 1 ? parts[1].substring(0, parts[1].length() - 1) : DEFAULT_THRESHOLD, exclusive);
        return new MinMaxConstraint(minValue, maxValue);
    }

    private JCRPathMatcher parsePathMatcher(LocationFactory locFactory, String path) throws RepositoryException {
        JCRPath knownPath = null;
        boolean forDescendants = false;
        boolean forAncestors = false;
        if (path.equals("*") || path.equals(".*")) {
            forDescendants = true;
            forAncestors = true;
        } else if (path.endsWith("*") && path.startsWith("*")) {
            forDescendants = true;
            forAncestors = true;
            knownPath = this.parsePath(path.substring(1, path.length() - 1), locFactory);
        } else if (path.endsWith("*")) {
            forDescendants = true;
            knownPath = this.parsePath(path.substring(0, path.length() - 1), locFactory);
        } else if (path.startsWith("*")) {
            forAncestors = true;
            knownPath = this.parsePath(path.substring(1), locFactory);
        } else {
            knownPath = this.parsePath(path, locFactory);
        }
        return new JCRPathMatcher(knownPath.getInternalPath(), forDescendants, forAncestors);
    }

    public class MinMaxConstraint {
        private final ConstraintRange minValue;
        private final ConstraintRange maxValue;
        private final ConstraintRange singleValue;

        public MinMaxConstraint(ConstraintRange minValue, ConstraintRange maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.singleValue = null;
        }

        public ConstraintRange getSingleValue() {
            return this.singleValue;
        }

        protected ConstraintRange getMax() {
            return this.maxValue;
        }

        protected ConstraintRange getMin() {
            return this.minValue;
        }
    }

    public class ConstraintRange {
        private final String value;
        private final boolean exclusive;

        public ConstraintRange(String value) {
            this.value = value;
            this.exclusive = false;
        }

        public ConstraintRange(String value, boolean exclusive) {
            this.value = value;
            this.exclusive = exclusive;
        }

        protected String getThreshold() {
            return this.value;
        }

        protected boolean isExclusive() {
            return this.exclusive;
        }
    }
}

