/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractSynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationActionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentMetadataMutatorAction<T extends SynchronizationActionContext>
extends AbstractSynchronizationAction<T> {
    private final RepositoryItemMetadata rollbackMetadata;

    protected AbstractContentMetadataMutatorAction(T context, ContentModification modification) {
        super(context, modification);
        RepositoryContentMetadata contentMetadata = ((SynchronizationActionContext)context).getInProgressMetadata();
        RepositoryRootMetadata rmd = contentMetadata.getRepositoryRootMetadata(modification.getRootName());
        if (rmd == null) {
            throw new IllegalStateException("Root " + modification.getRootName() + " unknown to " + contentMetadata);
        }
        this.rollbackMetadata = rmd.getItemMetadata(modification.getItem().getRelativePathElements());
    }

    protected void updateContentMetadata() {
        ContentModification mod = this.getRepositoryContentModification();
        RepositoryContentMetadata contentMetadata = ((SynchronizationActionContext)this.getContext()).getInProgressMetadata();
        RepositoryRootMetadata rmd = contentMetadata.getRepositoryRootMetadata(mod.getRootName());
        rmd.addItemMetadata(mod.getItem());
    }

    protected void rollbackContentMetadata() {
        ContentModification mod = this.getRepositoryContentModification();
        RepositoryContentMetadata contentMetadata = ((SynchronizationActionContext)this.getContext()).getInProgressMetadata();
        RepositoryRootMetadata rmd = contentMetadata.getRepositoryRootMetadata(mod.getRootName());
        if (this.rollbackMetadata == null) {
            rmd.removeItemMetadata(mod.getItem().getRelativePathElements());
        } else {
            rmd.addItemMetadata(this.rollbackMetadata);
        }
    }
}

