/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUtility;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateResourceConfigurationRunner
implements Runnable,
Callable<ConfigurationUpdateResponse> {
    private final Log log = LogFactory.getLog(UpdateResourceConfigurationRunner.class);
    private ConfigurationUpdateRequest request;
    private ConfigurationFacet configurationFacet;
    private ResourceType resourceType;
    private ConfigurationServerService configurationServerService;

    public UpdateResourceConfigurationRunner(ConfigurationServerService configurationServerService, ResourceType type, ConfigurationFacet facet, ConfigurationUpdateRequest request) {
        this.configurationServerService = configurationServerService;
        this.resourceType = type;
        this.configurationFacet = facet;
        this.request = request;
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            this.log.error((Object)"Error while chaining run to call", (Throwable)e);
        }
    }

    @Override
    public ConfigurationUpdateResponse call() throws Exception {
        ConfigurationUpdateResponse response;
        int requestId = this.request.getConfigurationUpdateId();
        ConfigurationUpdateReport report = new ConfigurationUpdateReport(this.request.getConfiguration());
        try {
            this.configurationFacet.updateResourceConfiguration(report);
            response = new ConfigurationUpdateResponse(requestId, report.getConfiguration(), report.getStatus(), report.getErrorMessage());
            if (response.getStatus() == ConfigurationUpdateStatus.INPROGRESS) {
                response.setErrorMessage("Configuration facet did not indicate success or failure - assuming failure.");
            }
            ConfigurationDefinition configurationDefinition = this.resourceType.getResourceConfigurationDefinition();
            ConfigurationUtility.normalizeConfiguration((Configuration)response.getConfiguration(), (ConfigurationDefinition)configurationDefinition);
            List errorMessages = ConfigurationUtility.validateConfiguration((Configuration)response.getConfiguration(), (ConfigurationDefinition)configurationDefinition);
            for (String errorMessage : errorMessages) {
                this.log.warn((Object)("Plugin Error: Invalid " + this.resourceType.getName() + " Resource configuration returned by " + this.resourceType.getPlugin() + " plugin - " + errorMessage));
            }
            if (response.getStatus() == ConfigurationUpdateStatus.SUCCESS) {
                response.setConfiguration(null);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Plugin Error: Exception thrown while updating Resource configuration for " + this.resourceType.getName() + " Resource with id [" + this.request.getResourceId() + "]."), t);
            response = new ConfigurationUpdateResponse(requestId, report.getConfiguration(), t);
        }
        if (this.configurationServerService != null) {
            this.configurationServerService.completeConfigurationUpdate(response);
        }
        return response;
    }
}

