/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock;

import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManager;

public abstract class AbstractSessionLockManager
implements SessionLockManager {
    protected final SessionDataManager transientManager;

    public AbstractSessionLockManager(SessionDataManager transientManager) {
        this.transientManager = transientManager;
    }

    protected abstract boolean isLockedPersisted(NodeData var1) throws LockException;

    protected abstract boolean isPersitedLockHolder(NodeImpl var1) throws RepositoryException;

    public boolean isLockHolder(NodeImpl node) throws RepositoryException {
        if (this.transientManager.isNew(node.getIdentifier()) && this.transientManager.isNew(node.getParentIdentifier())) {
            return true;
        }
        return this.isPersitedLockHolder(node);
    }

    public boolean isLocked(NodeData data) throws LockException {
        if (this.transientManager.isNew(data.getIdentifier())) {
            try {
                NodeData parentData = (NodeData)this.transientManager.getItemData(data.getParentIdentifier());
                if (parentData == null) {
                    return false;
                }
                return this.isLocked(parentData);
            }
            catch (RepositoryException e) {
                throw new LockException((Throwable)e);
            }
        }
        return this.isLockedPersisted(data);
    }
}

