/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.managed;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.services.binding.ServiceBindingMetadata;
import org.jboss.services.binding.managed.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingMetadataMapper
extends MetaMapper<Set<ServiceBindingMetadata>> {
    private static final Logger log = Logger.getLogger(ServiceBindingMetadataMapper.class);
    public static final CollectionMetaType TYPE;
    public static final CompositeMetaType SERVICE_BINDING_METADATA_TYPE;

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return Set.class;
    }

    public MetaValue createMetaValue(MetaType metaType, Set<ServiceBindingMetadata> object) {
        TreeSet<CompositeValue> tmp = new TreeSet<CompositeValue>(new FullyQualifiedNameComparator());
        for (ServiceBindingMetadata b : object) {
            try {
                MapCompositeValueSupport cvs = new MapCompositeValueSupport((MetaType)SERVICE_BINDING_METADATA_TYPE);
                cvs.put("serviceName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getServiceName())));
                cvs.put("bindingName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getBindingName())));
                cvs.put("fullyQualifiedName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getFullyQualifiedName())));
                cvs.put("description", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getDescription())));
                cvs.put("hostName", (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)b.getHostName())));
                cvs.put("port", (MetaValue)SimpleValueSupport.wrap((int)b.getPort()));
                cvs.put("fixedHostName", (MetaValue)SimpleValueSupport.wrap((boolean)b.isFixedHostName()));
                cvs.put("fixedPort", (MetaValue)SimpleValueSupport.wrap((boolean)b.isFixedPort()));
                tmp.add((CompositeValue)cvs);
            }
            catch (Exception e) {
                log.warn((Object)("Skipping binding: " + b), (Throwable)e);
            }
        }
        MetaValue[] elements = tmp.toArray(new MetaValue[tmp.size()]);
        CollectionValueSupport bindings = new CollectionValueSupport(TYPE, elements);
        return bindings;
    }

    public Set<ServiceBindingMetadata> unwrapMetaValue(MetaValue metaValue) {
        if (metaValue == null) {
            return null;
        }
        if (!(metaValue instanceof CollectionValue)) {
            throw new IllegalArgumentException(metaValue + " is not a " + CollectionValue.class.getSimpleName());
        }
        CollectionValue collValue = (CollectionValue)metaValue;
        MetaValue[] elements = collValue.getElements();
        HashSet<ServiceBindingMetadata> result = new HashSet<ServiceBindingMetadata>(elements.length);
        for (MetaValue element : elements) {
            if (!(element instanceof CompositeValue)) {
                throw new IllegalArgumentException(element + " is not a " + CompositeValue.class.getSimpleName());
            }
            CompositeValue compValue = (CompositeValue)element;
            String serviceName = Util.getValueFromComposite(compValue, "serviceName", String.class);
            String bindingName = Util.getValueFromComposite(compValue, "bindingName", String.class);
            String description = Util.getValueFromComposite(compValue, "description", String.class);
            String hostName = Util.getValueFromComposite(compValue, "hostName", String.class);
            Integer port = Util.getValueFromComposite(compValue, "port", Integer.class);
            if (port == null) {
                throw new IllegalStateException(element + " has no value for key 'port'");
            }
            Boolean fixedHostName = Util.getValueFromComposite(compValue, "fixedHostName", Boolean.class);
            Boolean fixedPort = Util.getValueFromComposite(compValue, "fixedPort", Boolean.class);
            ServiceBindingMetadata sbm = new ServiceBindingMetadata(serviceName, bindingName, hostName, port, fixedHostName == null ? false : fixedHostName, fixedPort == null ? false : fixedPort);
            sbm.setDescription(description);
            result.add(sbm);
        }
        return result;
    }

    static {
        String[] itemNames = new String[]{"serviceName", "bindingName", "fullyQualifiedName", "description", "hostName", "port", "fixedHostName", "fixedPort"};
        String[] itemDescriptions = new String[]{"the name of the service to which this binding applies", "a qualifier identifying which particular binding within the service this is", "the fully qualified binding name", "description of the binding", "the host name or string notation IP address to use for the binding", "the port to use for the binding", "whether the host name should remain fixed in all binding sets", "whether the port should remain fixed in all binding sets"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.INTEGER_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE};
        SERVICE_BINDING_METADATA_TYPE = new ImmutableCompositeMetaType(ServiceBindingMetadata.class.getName(), "Service Binding Metadata", itemNames, itemDescriptions, itemTypes);
        TYPE = new CollectionMetaType(Set.class.getName(), (MetaType)SERVICE_BINDING_METADATA_TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FullyQualifiedNameComparator
    implements Comparator<CompositeValue> {
        private FullyQualifiedNameComparator() {
        }

        @Override
        public int compare(CompositeValue o1, CompositeValue o2) {
            SimpleValue sv1 = (SimpleValue)o1.get("fullyQualifiedName");
            if (sv1 == null) {
                throw new IllegalStateException(o1 + " has no fullyQualifiedName");
            }
            SimpleValue sv2 = (SimpleValue)o2.get("fullyQualifiedName");
            if (sv2 == null) {
                throw new IllegalStateException(o2 + " has no fullyQualifiedName");
            }
            String name1 = (String)((Object)sv1.getValue());
            String name2 = (String)((Object)sv2.getValue());
            return name1.compareTo(name2);
        }
    }
}

