/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.EnumValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumValueSupport
extends AbstractMetaValue
implements EnumValue {
    private static final long serialVersionUID = -6472212391813711803L;
    private EnumMetaType metaType;
    private String value;

    public EnumValueSupport(EnumMetaType metaType, String value) {
        if (metaType == null) {
            throw new IllegalArgumentException("Null enum meta type");
        }
        this.metaType = metaType;
        this.value = value;
    }

    public EnumValueSupport(EnumMetaType metaType, Enum<?> value) {
        this(metaType, value.name());
    }

    @Override
    public EnumMetaType getMetaType() {
        return this.metaType;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof EnumValue)) {
            return false;
        }
        EnumValue other = (EnumValue)obj;
        if (!this.metaType.equals(other.getMetaType())) {
            return false;
        }
        String otherValue = other.getValue();
        if (this.value == null && otherValue == null) {
            return true;
        }
        if (this.value == null && otherValue != null) {
            return false;
        }
        return this.value.equals(otherValue);
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        return this.metaType + ":" + this.value;
    }
}

