/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcherSerializationTest
extends ChannelTestBase {
    private Channel channel;
    private Channel channel2;
    private RpcDispatcher disp;
    private RpcDispatcher disp2;

    public RpcDispatcherSerializationTest(String testName) {
        super(testName);
    }

    public void methodA(boolean b, long l) {
        System.out.println("methodA(" + b + ", " + l + ") called");
    }

    public boolean methodB() {
        return true;
    }

    public void methodC() {
        throw new IllegalArgumentException("dummy exception - for testing only");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.channel = this.createChannel("A");
        this.channel.setOpt(5, Boolean.TRUE);
        this.disp = new RpcDispatcher(this.channel, null, null, (Object)this);
        this.channel.connect("RpcDispatcherSerializationTestGroup");
        this.channel2 = this.createChannel("A");
        this.disp2 = new RpcDispatcher(this.channel2, null, null, (Object)this);
        this.channel2.connect("RpcDispatcherSerializationTestGroup");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.channel2.close();
        this.disp2.stop();
        this.disp.stop();
        this.channel.close();
    }

    public void testNonSerializableArgument() {
        try {
            this.disp.callRemoteMethods(null, "foo", new Object[]{new NonSerializable()}, new Class[]{NonSerializable.class}, 2, 5000L);
            RpcDispatcherSerializationTest.fail((String)"should throw NotSerializableException");
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause != null && cause instanceof NotSerializableException) {
                System.out.println("received RuntimeException with NotSerializableException as cause - this is expected");
            }
            RpcDispatcherSerializationTest.fail((String)("received " + t));
        }
    }

    public void testTargetMethodNotFound() {
        Vector<Address> members = this.channel.getView().getMembers();
        System.out.println("members are: " + members);
        RspList rsps = this.disp.callRemoteMethods(members, "foo", null, new Class[]{String.class, String.class}, 2, 8000L);
        System.out.println("responses:\n" + rsps + ", channel.view: " + this.channel.getView() + ", channel2.view: " + this.channel2.getView());
        RpcDispatcherSerializationTest.assertEquals((int)members.size(), (int)rsps.size());
        for (int i = 0; i < rsps.size(); ++i) {
            Rsp rsp = (Rsp)rsps.elementAt(i);
            RpcDispatcherSerializationTest.assertTrue((String)("response value is " + rsp.getValue()), (boolean)(rsp.getValue() instanceof NoSuchMethodException));
        }
    }

    public void testMarshaller() {
        MyMarshaller m = new MyMarshaller();
        this.disp.setRequestMarshaller(m);
        this.disp.setResponseMarshaller(m);
        this.disp2.setRequestMarshaller(m);
        this.disp2.setResponseMarshaller(m);
        RspList rsps = this.disp.callRemoteMethods(null, "methodA", new Object[]{Boolean.TRUE, new Long(322649L)}, new Class[]{Boolean.TYPE, Long.TYPE}, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals((int)2, (int)rsps.size());
        for (Rsp rsp : rsps.values()) {
            RpcDispatcherSerializationTest.assertNull((Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue((boolean)rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse((boolean)rsp.wasSuspected());
        }
        rsps = this.disp.callRemoteMethods(null, "methodB", null, (Class[])null, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals((int)2, (int)rsps.size());
        for (Rsp rsp : rsps.values()) {
            RpcDispatcherSerializationTest.assertNotNull((Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertEquals((Object)Boolean.TRUE, (Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue((boolean)rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse((boolean)rsp.wasSuspected());
        }
        rsps = this.disp.callRemoteMethods(null, "methodC", null, (Class[])null, 2, 0L);
        RpcDispatcherSerializationTest.assertEquals((int)2, (int)rsps.size());
        for (Rsp rsp : rsps.values()) {
            RpcDispatcherSerializationTest.assertNotNull((Object)rsp.getValue());
            RpcDispatcherSerializationTest.assertTrue((boolean)(rsp.getValue() instanceof Throwable));
            RpcDispatcherSerializationTest.assertTrue((boolean)rsp.wasReceived());
            RpcDispatcherSerializationTest.assertFalse((boolean)rsp.wasSuspected());
        }
        this.disp.setRequestMarshaller(null);
        this.disp.setResponseMarshaller(null);
        this.disp2.setRequestMarshaller(null);
        this.disp2.setResponseMarshaller(null);
    }

    public static Test suite() {
        return new TestSuite(RpcDispatcherSerializationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RpcDispatcherSerializationTest.suite());
    }

    static class NonSerializable {
        int i;

        NonSerializable() {
        }
    }

    static class MyMarshaller
    implements RpcDispatcher.Marshaller {
        static final byte NULL = 0;
        static final byte BOOL = 1;
        static final byte LONG = 2;
        static final byte OBJ = 3;

        MyMarshaller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] objectToByteBuffer(Object obj) throws Exception {
            byte[] byArray;
            ByteArrayOutputStream out = new ByteArrayOutputStream(24);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            try {
                if (obj == null) {
                    oos.writeByte(0);
                } else if (obj instanceof Boolean) {
                    oos.writeByte(1);
                    oos.writeBoolean((Boolean)obj);
                } else if (obj instanceof Long) {
                    oos.writeByte(2);
                    oos.writeLong((Long)obj);
                } else {
                    oos.writeByte(3);
                    oos.writeObject(obj);
                }
                oos.flush();
                byArray = out.toByteArray();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Util.close(oos);
                throw throwable;
            }
            Util.close(oos);
            return byArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            Object object;
            ObjectInputStream in;
            block11: {
                Long l;
                block10: {
                    Boolean bl;
                    block9: {
                        Object var5_5;
                        ByteArrayInputStream inp = new ByteArrayInputStream(buf);
                        in = new ObjectInputStream(inp);
                        try {
                            byte type = in.readByte();
                            switch (type) {
                                case 0: {
                                    var5_5 = null;
                                    Object var7_9 = null;
                                    break;
                                }
                                case 1: {
                                    bl = new Boolean(in.readBoolean());
                                    break block9;
                                }
                                case 2: {
                                    l = new Long(in.readLong());
                                    break block10;
                                }
                                case 3: {
                                    object = in.readObject();
                                    break block11;
                                }
                                default: {
                                    throw new IllegalArgumentException("incorrect type " + type);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var7_13 = null;
                            Util.close(in);
                            throw throwable;
                        }
                        Util.close(in);
                        return var5_5;
                    }
                    Object var7_10 = null;
                    Util.close(in);
                    return bl;
                }
                Object var7_11 = null;
                Util.close(in);
                return l;
            }
            Object var7_12 = null;
            Util.close(in);
            return object;
        }
    }
}

