/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import org.gatein.common.util.AbstractTypedMap;
import org.gatein.common.util.TypedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAdapters {
    private static final ArrayElementConverter<String> stringArrayElementConverter = new ArrayElementConverter(String.class);
    private static final AbstractTypedMap.Converter<String, String> stringConverter = AbstractTypedMap.Converter.identityConverter();

    public static <K, V> Map<K, V> adapt(Map<K, V[]> adapted, Class<? extends V> type) {
        if (adapted == null) {
            throw new IllegalArgumentException("Cannot adapt a null map");
        }
        ArrayElementConverter valueConverter = new ArrayElementConverter(type);
        AbstractTypedMap.Converter keyConverter = AbstractTypedMap.Converter.identityConverter();
        return new TypedMap(adapted, keyConverter, valueConverter);
    }

    public static Map<String, String> adapt(Map<String, String[]> adapted) {
        if (adapted == null) {
            throw new IllegalArgumentException("Cannot adapt a null map");
        }
        return new TypedMap(adapted, stringConverter, stringArrayElementConverter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayElementConverter<T>
    extends AbstractTypedMap.Converter<T, T[]> {
        private final Class<? extends T> type;

        private ArrayElementConverter(Class<? extends T> type) {
            if (type == null) {
                throw new IllegalArgumentException("No null type accepted");
            }
            this.type = type;
        }

        @Override
        protected T[] getInternal(T external) throws IllegalArgumentException, ClassCastException {
            if (external == null) {
                throw new NullPointerException();
            }
            Object[] array = (Object[])Array.newInstance(this.type, 1);
            array[0] = external;
            return array;
        }

        @Override
        protected T getExternal(T[] internal) throws IllegalArgumentException, ClassCastException {
            if (internal == null) {
                throw new IllegalStateException();
            }
            if (internal.length == 0) {
                throw new IllegalStateException();
            }
            return internal[0];
        }

        @Override
        protected boolean equals(T[] left, T[] right) {
            return Arrays.equals(left, right);
        }
    }
}

